/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.extension.rev150811;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.OcpHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.OcpMsgType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.extension.rev150811.ReDirectOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.extension.rev150811.RedirectOutput;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class ReDirectOutputBuilder
implements Builder<ReDirectOutput> {
    private OcpMsgType _msgType;
    private String _result;
    private Long _xid;
    Map<Class<? extends Augmentation<ReDirectOutput>>, Augmentation<ReDirectOutput>> augmentation = Collections.emptyMap();

    public ReDirectOutputBuilder() {
    }

    public ReDirectOutputBuilder(OcpHeader arg) {
        this._msgType = arg.getMsgType();
        this._xid = arg.getXid();
    }

    public ReDirectOutputBuilder(RedirectOutput arg) {
        this._result = arg.getResult();
    }

    public ReDirectOutputBuilder(ReDirectOutput base) {
        AugmentationHolder casted;
        this._msgType = base.getMsgType();
        this._result = base.getResult();
        this._xid = base.getXid();
        if (base instanceof ReDirectOutputImpl) {
            ReDirectOutputImpl impl = (ReDirectOutputImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<ReDirectOutput>>, Augmentation<ReDirectOutput>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<ReDirectOutput>>, Augmentation<ReDirectOutput>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof OcpHeader) {
            this._msgType = ((OcpHeader)arg).getMsgType();
            this._xid = ((OcpHeader)arg).getXid();
            isValidArg = true;
        }
        if (arg instanceof RedirectOutput) {
            this._result = ((RedirectOutput)arg).getResult();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.OcpHeader, org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.extension.rev150811.RedirectOutput] \nbut was: " + arg);
        }
    }

    public OcpMsgType getMsgType() {
        return this._msgType;
    }

    public String getResult() {
        return this._result;
    }

    public Long getXid() {
        return this._xid;
    }

    public <E extends Augmentation<ReDirectOutput>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public ReDirectOutputBuilder setMsgType(OcpMsgType value) {
        this._msgType = value;
        return this;
    }

    public ReDirectOutputBuilder setResult(String value) {
        this._result = value;
        return this;
    }

    private static void checkXidRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..4294967295]].", value));
    }

    public ReDirectOutputBuilder setXid(Long value) {
        if (value != null) {
            ReDirectOutputBuilder.checkXidRange(value);
        }
        this._xid = value;
        return this;
    }

    public ReDirectOutputBuilder addAugmentation(Class<? extends Augmentation<ReDirectOutput>> augmentationType, Augmentation<ReDirectOutput> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<ReDirectOutput>>, Augmentation<ReDirectOutput>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public ReDirectOutputBuilder removeAugmentation(Class<? extends Augmentation<ReDirectOutput>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public ReDirectOutput build() {
        return new ReDirectOutputImpl(this);
    }

    private static final class ReDirectOutputImpl
    implements ReDirectOutput {
        private final OcpMsgType _msgType;
        private final String _result;
        private final Long _xid;
        private Map<Class<? extends Augmentation<ReDirectOutput>>, Augmentation<ReDirectOutput>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<ReDirectOutput> getImplementedInterface() {
            return ReDirectOutput.class;
        }

        private ReDirectOutputImpl(ReDirectOutputBuilder base) {
            this._msgType = base.getMsgType();
            this._result = base.getResult();
            this._xid = base.getXid();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<ReDirectOutput>>, Augmentation<ReDirectOutput>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<ReDirectOutput>>, Augmentation<ReDirectOutput>>(base.augmentation);
                }
            }
        }

        @Override
        public OcpMsgType getMsgType() {
            return this._msgType;
        }

        @Override
        public String getResult() {
            return this._result;
        }

        @Override
        public Long getXid() {
            return this._xid;
        }

        public <E extends Augmentation<ReDirectOutput>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode((Object)this._msgType);
            result = 31 * result + Objects.hashCode(this._result);
            result = 31 * result + Objects.hashCode(this._xid);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!ReDirectOutput.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            ReDirectOutput other = (ReDirectOutput)obj;
            if (!Objects.equals((Object)this._msgType, (Object)other.getMsgType())) {
                return false;
            }
            if (!Objects.equals(this._result, other.getResult())) {
                return false;
            }
            if (!Objects.equals(this._xid, other.getXid())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                ReDirectOutputImpl otherImpl = (ReDirectOutputImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<ReDirectOutput>>, Augmentation<ReDirectOutput>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "ReDirectOutput [";
            StringBuilder builder = new StringBuilder(name);
            if (this._msgType != null) {
                builder.append("_msgType=");
                builder.append((Object)this._msgType);
                builder.append(", ");
            }
            if (this._result != null) {
                builder.append("_result=");
                builder.append(this._result);
                builder.append(", ");
            }
            if (this._xid != null) {
                builder.append("_xid=");
                builder.append(this._xid);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

