/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.protocol.rev150811;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.ObjType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.OcpHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.OcpMsgType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.createobjinput.Param;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.protocol.rev150811.CreateObjInput;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class CreateObjInputBuilder
implements Builder<CreateObjInput> {
    private OcpMsgType _msgType;
    private ObjType _objType;
    private List<Param> _param;
    private Long _xid;
    Map<Class<? extends Augmentation<CreateObjInput>>, Augmentation<CreateObjInput>> augmentation = Collections.emptyMap();

    public CreateObjInputBuilder() {
    }

    public CreateObjInputBuilder(OcpHeader arg) {
        this._msgType = arg.getMsgType();
        this._xid = arg.getXid();
    }

    public CreateObjInputBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.CreateObjInput arg) {
        this._objType = arg.getObjType();
        this._param = arg.getParam();
    }

    public CreateObjInputBuilder(CreateObjInput base) {
        AugmentationHolder casted;
        this._msgType = base.getMsgType();
        this._objType = base.getObjType();
        this._param = base.getParam();
        this._xid = base.getXid();
        if (base instanceof CreateObjInputImpl) {
            CreateObjInputImpl impl = (CreateObjInputImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<CreateObjInput>>, Augmentation<CreateObjInput>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<CreateObjInput>>, Augmentation<CreateObjInput>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.CreateObjInput) {
            this._objType = ((org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.CreateObjInput)arg).getObjType();
            this._param = ((org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.CreateObjInput)arg).getParam();
            isValidArg = true;
        }
        if (arg instanceof OcpHeader) {
            this._msgType = ((OcpHeader)arg).getMsgType();
            this._xid = ((OcpHeader)arg).getXid();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.CreateObjInput, org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.OcpHeader] \nbut was: " + arg);
        }
    }

    public OcpMsgType getMsgType() {
        return this._msgType;
    }

    public ObjType getObjType() {
        return this._objType;
    }

    public List<Param> getParam() {
        return this._param;
    }

    public Long getXid() {
        return this._xid;
    }

    public <E extends Augmentation<CreateObjInput>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public CreateObjInputBuilder setMsgType(OcpMsgType value) {
        this._msgType = value;
        return this;
    }

    public CreateObjInputBuilder setObjType(ObjType value) {
        this._objType = value;
        return this;
    }

    public CreateObjInputBuilder setParam(List<Param> value) {
        this._param = value;
        return this;
    }

    private static void checkXidRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..4294967295]].", value));
    }

    public CreateObjInputBuilder setXid(Long value) {
        if (value != null) {
            CreateObjInputBuilder.checkXidRange(value);
        }
        this._xid = value;
        return this;
    }

    public CreateObjInputBuilder addAugmentation(Class<? extends Augmentation<CreateObjInput>> augmentationType, Augmentation<CreateObjInput> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<CreateObjInput>>, Augmentation<CreateObjInput>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public CreateObjInputBuilder removeAugmentation(Class<? extends Augmentation<CreateObjInput>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public CreateObjInput build() {
        return new CreateObjInputImpl(this);
    }

    private static final class CreateObjInputImpl
    implements CreateObjInput {
        private final OcpMsgType _msgType;
        private final ObjType _objType;
        private final List<Param> _param;
        private final Long _xid;
        private Map<Class<? extends Augmentation<CreateObjInput>>, Augmentation<CreateObjInput>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<CreateObjInput> getImplementedInterface() {
            return CreateObjInput.class;
        }

        private CreateObjInputImpl(CreateObjInputBuilder base) {
            this._msgType = base.getMsgType();
            this._objType = base.getObjType();
            this._param = base.getParam();
            this._xid = base.getXid();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<CreateObjInput>>, Augmentation<CreateObjInput>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<CreateObjInput>>, Augmentation<CreateObjInput>>(base.augmentation);
                }
            }
        }

        @Override
        public OcpMsgType getMsgType() {
            return this._msgType;
        }

        @Override
        public ObjType getObjType() {
            return this._objType;
        }

        @Override
        public List<Param> getParam() {
            return this._param;
        }

        @Override
        public Long getXid() {
            return this._xid;
        }

        public <E extends Augmentation<CreateObjInput>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode((Object)this._msgType);
            result = 31 * result + Objects.hashCode(this._objType);
            result = 31 * result + Objects.hashCode(this._param);
            result = 31 * result + Objects.hashCode(this._xid);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!CreateObjInput.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            CreateObjInput other = (CreateObjInput)obj;
            if (!Objects.equals((Object)this._msgType, (Object)other.getMsgType())) {
                return false;
            }
            if (!Objects.equals(this._objType, other.getObjType())) {
                return false;
            }
            if (!Objects.equals(this._param, other.getParam())) {
                return false;
            }
            if (!Objects.equals(this._xid, other.getXid())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                CreateObjInputImpl otherImpl = (CreateObjInputImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<CreateObjInput>>, Augmentation<CreateObjInput>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "CreateObjInput [";
            StringBuilder builder = new StringBuilder(name);
            if (this._msgType != null) {
                builder.append("_msgType=");
                builder.append((Object)this._msgType);
                builder.append(", ");
            }
            if (this._objType != null) {
                builder.append("_objType=");
                builder.append(this._objType);
                builder.append(", ");
            }
            if (this._param != null) {
                builder.append("_param=");
                builder.append(this._param);
                builder.append(", ");
            }
            if (this._xid != null) {
                builder.append("_xid=");
                builder.append(this._xid);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

