/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.protocol.rev150811;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.ObjId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.OcpHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.OcpMsgType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.protocol.rev150811.GetFaultInput;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class GetFaultInputBuilder
implements Builder<GetFaultInput> {
    private OcpMsgType _msgType;
    private ObjId _objId;
    private Long _xid;
    private Boolean _eventDrivenReporting;
    Map<Class<? extends Augmentation<GetFaultInput>>, Augmentation<GetFaultInput>> augmentation = Collections.emptyMap();

    public GetFaultInputBuilder() {
    }

    public GetFaultInputBuilder(OcpHeader arg) {
        this._msgType = arg.getMsgType();
        this._xid = arg.getXid();
    }

    public GetFaultInputBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.GetFaultInput arg) {
        this._objId = arg.getObjId();
        this._eventDrivenReporting = arg.isEventDrivenReporting();
    }

    public GetFaultInputBuilder(GetFaultInput base) {
        AugmentationHolder casted;
        this._msgType = base.getMsgType();
        this._objId = base.getObjId();
        this._xid = base.getXid();
        this._eventDrivenReporting = base.isEventDrivenReporting();
        if (base instanceof GetFaultInputImpl) {
            GetFaultInputImpl impl = (GetFaultInputImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<GetFaultInput>>, Augmentation<GetFaultInput>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<GetFaultInput>>, Augmentation<GetFaultInput>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.GetFaultInput) {
            this._objId = ((org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.GetFaultInput)arg).getObjId();
            this._eventDrivenReporting = ((org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.GetFaultInput)arg).isEventDrivenReporting();
            isValidArg = true;
        }
        if (arg instanceof OcpHeader) {
            this._msgType = ((OcpHeader)arg).getMsgType();
            this._xid = ((OcpHeader)arg).getXid();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.GetFaultInput, org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.OcpHeader] \nbut was: " + arg);
        }
    }

    public OcpMsgType getMsgType() {
        return this._msgType;
    }

    public ObjId getObjId() {
        return this._objId;
    }

    public Long getXid() {
        return this._xid;
    }

    public Boolean isEventDrivenReporting() {
        return this._eventDrivenReporting;
    }

    public <E extends Augmentation<GetFaultInput>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public GetFaultInputBuilder setMsgType(OcpMsgType value) {
        this._msgType = value;
        return this;
    }

    public GetFaultInputBuilder setObjId(ObjId value) {
        this._objId = value;
        return this;
    }

    private static void checkXidRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..4294967295]].", value));
    }

    public GetFaultInputBuilder setXid(Long value) {
        if (value != null) {
            GetFaultInputBuilder.checkXidRange(value);
        }
        this._xid = value;
        return this;
    }

    public GetFaultInputBuilder setEventDrivenReporting(Boolean value) {
        this._eventDrivenReporting = value;
        return this;
    }

    public GetFaultInputBuilder addAugmentation(Class<? extends Augmentation<GetFaultInput>> augmentationType, Augmentation<GetFaultInput> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<GetFaultInput>>, Augmentation<GetFaultInput>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public GetFaultInputBuilder removeAugmentation(Class<? extends Augmentation<GetFaultInput>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public GetFaultInput build() {
        return new GetFaultInputImpl(this);
    }

    private static final class GetFaultInputImpl
    implements GetFaultInput {
        private final OcpMsgType _msgType;
        private final ObjId _objId;
        private final Long _xid;
        private final Boolean _eventDrivenReporting;
        private Map<Class<? extends Augmentation<GetFaultInput>>, Augmentation<GetFaultInput>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<GetFaultInput> getImplementedInterface() {
            return GetFaultInput.class;
        }

        private GetFaultInputImpl(GetFaultInputBuilder base) {
            this._msgType = base.getMsgType();
            this._objId = base.getObjId();
            this._xid = base.getXid();
            this._eventDrivenReporting = base.isEventDrivenReporting();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<GetFaultInput>>, Augmentation<GetFaultInput>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<GetFaultInput>>, Augmentation<GetFaultInput>>(base.augmentation);
                }
            }
        }

        @Override
        public OcpMsgType getMsgType() {
            return this._msgType;
        }

        @Override
        public ObjId getObjId() {
            return this._objId;
        }

        @Override
        public Long getXid() {
            return this._xid;
        }

        @Override
        public Boolean isEventDrivenReporting() {
            return this._eventDrivenReporting;
        }

        public <E extends Augmentation<GetFaultInput>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode((Object)this._msgType);
            result = 31 * result + Objects.hashCode(this._objId);
            result = 31 * result + Objects.hashCode(this._xid);
            result = 31 * result + Objects.hashCode(this._eventDrivenReporting);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!GetFaultInput.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            GetFaultInput other = (GetFaultInput)obj;
            if (!Objects.equals((Object)this._msgType, (Object)other.getMsgType())) {
                return false;
            }
            if (!Objects.equals(this._objId, other.getObjId())) {
                return false;
            }
            if (!Objects.equals(this._xid, other.getXid())) {
                return false;
            }
            if (!Objects.equals(this._eventDrivenReporting, other.isEventDrivenReporting())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                GetFaultInputImpl otherImpl = (GetFaultInputImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<GetFaultInput>>, Augmentation<GetFaultInput>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "GetFaultInput [";
            StringBuilder builder = new StringBuilder(name);
            if (this._msgType != null) {
                builder.append("_msgType=");
                builder.append((Object)this._msgType);
                builder.append(", ");
            }
            if (this._objId != null) {
                builder.append("_objId=");
                builder.append(this._objId);
                builder.append(", ");
            }
            if (this._xid != null) {
                builder.append("_xid=");
                builder.append(this._xid);
                builder.append(", ");
            }
            if (this._eventDrivenReporting != null) {
                builder.append("_eventDrivenReporting=");
                builder.append(this._eventDrivenReporting);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

