/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.protocol.rev150811;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.ObjId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.OcpHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.OcpMsgType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.StateType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.StateVal;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.protocol.rev150811.StateChangeInd;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class StateChangeIndBuilder
implements Builder<StateChangeInd> {
    private OcpMsgType _msgType;
    private ObjId _objId;
    private StateType _stateType;
    private StateVal _stateValue;
    private Long _xid;
    Map<Class<? extends Augmentation<StateChangeInd>>, Augmentation<StateChangeInd>> augmentation = Collections.emptyMap();

    public StateChangeIndBuilder() {
    }

    public StateChangeIndBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.StateChangeInd arg) {
        this._objId = arg.getObjId();
        this._stateType = arg.getStateType();
        this._stateValue = arg.getStateValue();
    }

    public StateChangeIndBuilder(OcpHeader arg) {
        this._msgType = arg.getMsgType();
        this._xid = arg.getXid();
    }

    public StateChangeIndBuilder(StateChangeInd base) {
        AugmentationHolder casted;
        this._msgType = base.getMsgType();
        this._objId = base.getObjId();
        this._stateType = base.getStateType();
        this._stateValue = base.getStateValue();
        this._xid = base.getXid();
        if (base instanceof StateChangeIndImpl) {
            StateChangeIndImpl impl = (StateChangeIndImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<StateChangeInd>>, Augmentation<StateChangeInd>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<StateChangeInd>>, Augmentation<StateChangeInd>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.StateChangeInd) {
            this._objId = ((org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.StateChangeInd)arg).getObjId();
            this._stateType = ((org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.StateChangeInd)arg).getStateType();
            this._stateValue = ((org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.StateChangeInd)arg).getStateValue();
            isValidArg = true;
        }
        if (arg instanceof OcpHeader) {
            this._msgType = ((OcpHeader)arg).getMsgType();
            this._xid = ((OcpHeader)arg).getXid();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.StateChangeInd, org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.OcpHeader] \nbut was: " + arg);
        }
    }

    public OcpMsgType getMsgType() {
        return this._msgType;
    }

    public ObjId getObjId() {
        return this._objId;
    }

    public StateType getStateType() {
        return this._stateType;
    }

    public StateVal getStateValue() {
        return this._stateValue;
    }

    public Long getXid() {
        return this._xid;
    }

    public <E extends Augmentation<StateChangeInd>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public StateChangeIndBuilder setMsgType(OcpMsgType value) {
        this._msgType = value;
        return this;
    }

    public StateChangeIndBuilder setObjId(ObjId value) {
        this._objId = value;
        return this;
    }

    public StateChangeIndBuilder setStateType(StateType value) {
        this._stateType = value;
        return this;
    }

    public StateChangeIndBuilder setStateValue(StateVal value) {
        this._stateValue = value;
        return this;
    }

    private static void checkXidRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..4294967295]].", value));
    }

    public StateChangeIndBuilder setXid(Long value) {
        if (value != null) {
            StateChangeIndBuilder.checkXidRange(value);
        }
        this._xid = value;
        return this;
    }

    public StateChangeIndBuilder addAugmentation(Class<? extends Augmentation<StateChangeInd>> augmentationType, Augmentation<StateChangeInd> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<StateChangeInd>>, Augmentation<StateChangeInd>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public StateChangeIndBuilder removeAugmentation(Class<? extends Augmentation<StateChangeInd>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public StateChangeInd build() {
        return new StateChangeIndImpl(this);
    }

    private static final class StateChangeIndImpl
    implements StateChangeInd {
        private final OcpMsgType _msgType;
        private final ObjId _objId;
        private final StateType _stateType;
        private final StateVal _stateValue;
        private final Long _xid;
        private Map<Class<? extends Augmentation<StateChangeInd>>, Augmentation<StateChangeInd>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<StateChangeInd> getImplementedInterface() {
            return StateChangeInd.class;
        }

        private StateChangeIndImpl(StateChangeIndBuilder base) {
            this._msgType = base.getMsgType();
            this._objId = base.getObjId();
            this._stateType = base.getStateType();
            this._stateValue = base.getStateValue();
            this._xid = base.getXid();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<StateChangeInd>>, Augmentation<StateChangeInd>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<StateChangeInd>>, Augmentation<StateChangeInd>>(base.augmentation);
                }
            }
        }

        @Override
        public OcpMsgType getMsgType() {
            return this._msgType;
        }

        @Override
        public ObjId getObjId() {
            return this._objId;
        }

        @Override
        public StateType getStateType() {
            return this._stateType;
        }

        @Override
        public StateVal getStateValue() {
            return this._stateValue;
        }

        @Override
        public Long getXid() {
            return this._xid;
        }

        public <E extends Augmentation<StateChangeInd>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode((Object)this._msgType);
            result = 31 * result + Objects.hashCode(this._objId);
            result = 31 * result + Objects.hashCode((Object)this._stateType);
            result = 31 * result + Objects.hashCode((Object)this._stateValue);
            result = 31 * result + Objects.hashCode(this._xid);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!StateChangeInd.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            StateChangeInd other = (StateChangeInd)obj;
            if (!Objects.equals((Object)this._msgType, (Object)other.getMsgType())) {
                return false;
            }
            if (!Objects.equals(this._objId, other.getObjId())) {
                return false;
            }
            if (!Objects.equals((Object)this._stateType, (Object)other.getStateType())) {
                return false;
            }
            if (!Objects.equals((Object)this._stateValue, (Object)other.getStateValue())) {
                return false;
            }
            if (!Objects.equals(this._xid, other.getXid())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                StateChangeIndImpl otherImpl = (StateChangeIndImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<StateChangeInd>>, Augmentation<StateChangeInd>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "StateChangeInd [";
            StringBuilder builder = new StringBuilder(name);
            if (this._msgType != null) {
                builder.append("_msgType=");
                builder.append((Object)this._msgType);
                builder.append(", ");
            }
            if (this._objId != null) {
                builder.append("_objId=");
                builder.append(this._objId);
                builder.append(", ");
            }
            if (this._stateType != null) {
                builder.append("_stateType=");
                builder.append((Object)this._stateType);
                builder.append(", ");
            }
            if (this._stateValue != null) {
                builder.append("_stateValue=");
                builder.append((Object)this._stateValue);
                builder.append(", ");
            }
            if (this._xid != null) {
                builder.append("_xid=");
                builder.append(this._xid);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

