/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.xsd.types.rev150811;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;

public class XsdDateTime
implements Serializable {
    private static final long serialVersionUID = 1059001725806074407L;
    private static final Pattern[] patterns;
    public static final List<String> PATTERN_CONSTANTS;
    private final String _value;

    private static void check_valueLength(String value) {
    }

    @ConstructorProperties(value={"value"})
    public XsdDateTime(String _value) {
        if (_value != null) {
            XsdDateTime.check_valueLength(_value);
        }
        Preconditions.checkNotNull((Object)_value, (Object)"Supplied value may not be null");
        for (Pattern p : patterns) {
            Preconditions.checkArgument((boolean)p.matcher(_value).matches(), (String)"Supplied value \"%s\" does not match required pattern \"%s\"", (Object)_value, (Object)p);
        }
        this._value = _value;
    }

    public XsdDateTime(XsdDateTime source) {
        this._value = source._value;
    }

    public static XsdDateTime getDefaultInstance(String defaultValue) {
        return new XsdDateTime(defaultValue);
    }

    public String getValue() {
        return this._value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Objects.hashCode(this._value);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        XsdDateTime other = (XsdDateTime)obj;
        return Objects.equals(this._value, other._value);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(XsdDateTime.class.getSimpleName()).append(" [");
        boolean first = true;
        if (this._value != null) {
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("_value=");
            builder.append(this._value);
        }
        return builder.append(']').toString();
    }

    static {
        PATTERN_CONSTANTS = ImmutableList.of((Object)"^-?\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}(\\.\\d+)?(Z|(\\+|-)\\d{2}:\\d{2})$");
        Pattern[] a = new Pattern[PATTERN_CONSTANTS.size()];
        int i = 0;
        for (String regEx : PATTERN_CONSTANTS) {
            a[i++] = Pattern.compile(regEx);
        }
        patterns = a;
    }
}

