/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.ocpjava.protocol.impl.core;

import com.google.common.base.Preconditions;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import org.opendaylight.ocpjava.protocol.impl.core.connection.MessageConsumer;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.system.rev150811.DisconnectEventBuilder;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DelegatingInboundHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(DelegatingInboundHandler.class);
    private final MessageConsumer consumer;
    private boolean inactiveMessageSent = false;

    public DelegatingInboundHandler(MessageConsumer connectionAdapter) {
        LOGGER.trace("Creating DelegatingInboundHandler");
        this.consumer = (MessageConsumer)Preconditions.checkNotNull((Object)connectionAdapter);
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        LOGGER.trace("DelegatingInboundHandler channelRead, msg = " + msg.toString());
        this.consumer.consume((DataObject)msg);
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        LOGGER.debug("Channel inactive");
        if (!this.inactiveMessageSent) {
            DisconnectEventBuilder builder = new DisconnectEventBuilder();
            builder.setInfo("Channel inactive");
            this.consumer.consume((DataObject)builder.build());
            this.inactiveMessageSent = true;
        }
    }

    public void channelUnregistered(ChannelHandlerContext ctx) {
        LOGGER.debug("Channel unregistered");
        if (!this.inactiveMessageSent) {
            DisconnectEventBuilder builder = new DisconnectEventBuilder();
            builder.setInfo("Channel unregistered");
            this.consumer.consume((DataObject)builder.build());
            this.inactiveMessageSent = true;
        }
    }
}

