/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.ocpjava.protocol.impl.core;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.timeout.ReadTimeoutHandler;
import java.util.concurrent.TimeUnit;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.system.rev150811.RadioHeadIdleEventBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdleHandler
extends ReadTimeoutHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(IdleHandler.class);
    private boolean first = true;

    public IdleHandler(long readerIdleTime, TimeUnit unit) {
        super(readerIdleTime, unit);
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        super.channelRead(ctx, msg);
        this.first = true;
    }

    protected void readTimedOut(ChannelHandlerContext ctx) throws Exception {
        if (this.first) {
            LOGGER.debug("RadioHead idle");
            RadioHeadIdleEventBuilder builder = new RadioHeadIdleEventBuilder();
            builder.setInfo("RadioHead idle");
            ctx.fireChannelRead((Object)builder.build());
            this.first = false;
        }
    }
}

