/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.ocpjava.protocol.impl.core;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageDecoder;
import java.util.List;
import org.opendaylight.ocpjava.protocol.impl.core.DefaultMessageWrapper;
import org.opendaylight.ocpjava.protocol.impl.deserialization.DeserializationFactory;
import org.opendaylight.ocpjava.statistics.CounterEventTypes;
import org.opendaylight.ocpjava.statistics.OcpStatisticsCounters;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OCPDecoder
extends MessageToMessageDecoder<DefaultMessageWrapper> {
    private static final Logger LOGGER = LoggerFactory.getLogger(OCPDecoder.class);
    private final OcpStatisticsCounters statisticsCounter;
    private DeserializationFactory deserializationFactory;

    public OCPDecoder() {
        LOGGER.trace("Creating OCP Decoder");
        this.statisticsCounter = OcpStatisticsCounters.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void decode(ChannelHandlerContext ctx, DefaultMessageWrapper msg, List<Object> out) throws Exception {
        this.statisticsCounter.incrementCounter(CounterEventTypes.US_RECEIVED_IN_OCPJAVA);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("DefaultMessageWrapper received");
        }
        try {
            DataObject dataObject = this.deserializationFactory.deserialize(msg.getVersionId(), msg.getTypeId(), msg.getMessageBuffer());
            if (dataObject == null) {
                LOGGER.warn("Translated POJO is null");
                this.statisticsCounter.incrementCounter(CounterEventTypes.US_DECODE_FAIL);
            } else {
                out.add(dataObject);
                this.statisticsCounter.incrementCounter(CounterEventTypes.US_DECODE_SUCCESS);
            }
        }
        catch (Exception e) {
            LOGGER.warn("Message deserialization failed", (Throwable)e);
            this.statisticsCounter.incrementCounter(CounterEventTypes.US_DECODE_FAIL);
        }
        finally {
            msg.getMessageBuffer().clear();
        }
    }

    public void setDeserializationFactory(DeserializationFactory deserializationFactory) {
        this.deserializationFactory = deserializationFactory;
    }
}

