/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.ocpjava.protocol.impl.core;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToByteEncoder;
import io.netty.util.concurrent.Future;
import org.opendaylight.ocpjava.protocol.impl.core.connection.MessageListenerWrapper;
import org.opendaylight.ocpjava.protocol.impl.serialization.SerializationFactory;
import org.opendaylight.ocpjava.statistics.CounterEventTypes;
import org.opendaylight.ocpjava.statistics.OcpStatisticsCounters;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OCPEncoder
extends MessageToByteEncoder<MessageListenerWrapper> {
    private static final Logger LOGGER = LoggerFactory.getLogger(OCPEncoder.class);
    private SerializationFactory serializationFactory;
    private OcpStatisticsCounters statisticsCounters = OcpStatisticsCounters.getInstance();

    public OCPEncoder() {
        LOGGER.trace("Creating OCPEncoder");
    }

    protected void encode(ChannelHandlerContext ctx, MessageListenerWrapper wrapper, ByteBuf out) throws Exception {
        LOGGER.trace("Encoding");
        try {
            this.serializationFactory.messageToBuffer((short)1, out, (DataObject)wrapper.getMsg());
            this.statisticsCounters.incrementCounter(CounterEventTypes.DS_ENCODE_SUCCESS);
        }
        catch (Exception e) {
            LOGGER.warn("Message serialization failed ", (Throwable)e);
            this.statisticsCounters.incrementCounter(CounterEventTypes.DS_ENCODE_FAIL);
            ChannelFuture newFailedFuture = ctx.newFailedFuture((Throwable)e);
            wrapper.getListener().operationComplete((Future)newFailedFuture);
            out.clear();
            return;
        }
    }

    public void setSerializationFactory(SerializationFactory serializationFactory) {
        this.serializationFactory = serializationFactory;
    }
}

