/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.ocpjava.protocol.impl.core;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.opendaylight.ocpjava.protocol.impl.core.DefaultMessageWrapper;
import org.opendaylight.ocpjava.protocol.impl.core.XmlAttribute;
import org.opendaylight.ocpjava.protocol.impl.core.XmlCharacters;
import org.opendaylight.ocpjava.protocol.impl.core.XmlElementEnd;
import org.opendaylight.ocpjava.protocol.impl.core.XmlElementStart;
import org.opendaylight.ocpjava.protocol.impl.core.XmlNamespace;
import org.opendaylight.ocpjava.protocol.impl.core.connection.ConnectionFacade;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.OcpMsgType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OCPXmlDecoder
extends ByteToMessageDecoder {
    private static final Logger LOGGER = LoggerFactory.getLogger(OCPXmlDecoder.class);
    private static final XMLInputFactory factory = XMLInputFactory.newFactory();
    private List<Object> out;
    private String buf = "";
    private List<Object> xmlElms;
    private boolean bodyElmFound;
    private int msgType;

    public OCPXmlDecoder(ConnectionFacade connectionFacade, boolean tlsPresent) {
        LOGGER.trace("Creating OCPXmlDecoder");
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        if (in.readableBytes() == 0) {
            return;
        }
        this.out = out;
        byte[] bs = new byte[in.readableBytes()];
        in.readBytes(bs);
        this.buf = this.buf + new String(bs, "UTF-8");
        int index = this.buf.indexOf("</msg>");
        while (index != -1) {
            String msg = this.buf.substring(0, index + 6);
            LOGGER.debug("Message = {}", (Object)msg);
            this.parseDocument(msg);
            if (index + 6 == this.buf.length()) {
                this.buf = "";
                break;
            }
            this.buf = this.buf.substring(index + 6, this.buf.length());
            index = this.buf.indexOf("</msg>");
        }
    }

    private void parseDocument(String msg) {
        try {
            XMLStreamReader reader = factory.createXMLStreamReader(new StringReader(msg));
            while (reader.hasNext()) {
                this.parseEvent(reader);
                reader.next();
            }
            reader.close();
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
        }
    }

    private void parseEvent(XMLStreamReader streamReader) {
        switch (streamReader.getEventType()) {
            case 1: {
                int x;
                XmlElementStart elementStart = new XmlElementStart(streamReader.getLocalName(), streamReader.getName().getNamespaceURI(), streamReader.getPrefix());
                for (x = 0; x < streamReader.getAttributeCount(); ++x) {
                    XmlAttribute attribute = new XmlAttribute(streamReader.getAttributeType(x), streamReader.getAttributeLocalName(x), streamReader.getAttributePrefix(x), streamReader.getAttributeNamespace(x), streamReader.getAttributeValue(x));
                    elementStart.attributes().add(attribute);
                }
                for (x = 0; x < streamReader.getNamespaceCount(); ++x) {
                    XmlNamespace namespace = new XmlNamespace(streamReader.getNamespacePrefix(x), streamReader.getNamespaceURI(x));
                    elementStart.namespaces().add(namespace);
                }
                if (elementStart.name().equals("msg")) {
                    this.xmlElms = new ArrayList<Object>();
                    this.bodyElmFound = false;
                } else if (elementStart.name().equals("body")) {
                    this.bodyElmFound = true;
                } else if (this.bodyElmFound) {
                    boolean isOcpMsgType = EnumSet.allOf(OcpMsgType.class).toString().contains(elementStart.name().toUpperCase());
                    if (!isOcpMsgType) {
                        LOGGER.warn("OCPXmlDecoder - unknown OcpMsgType format");
                        this.msgType = 99;
                    } else {
                        this.msgType = OcpMsgType.valueOf((String)elementStart.name().toUpperCase()).getIntValue();
                    }
                    this.bodyElmFound = false;
                    LOGGER.trace("Message start: " + elementStart.name());
                }
                this.xmlElms.add(elementStart);
                break;
            }
            case 2: {
                XmlElementEnd elementEnd = new XmlElementEnd(streamReader.getLocalName(), streamReader.getName().getNamespaceURI(), streamReader.getPrefix());
                for (int x = 0; x < streamReader.getNamespaceCount(); ++x) {
                    XmlNamespace namespace = new XmlNamespace(streamReader.getNamespacePrefix(x), streamReader.getNamespaceURI(x));
                    elementEnd.namespaces().add(namespace);
                }
                this.xmlElms.add(elementEnd);
                if (!elementEnd.name().equals("msg")) break;
                LOGGER.trace("Message end: " + elementEnd.name());
                this.out.add(new DefaultMessageWrapper(1, this.msgType, this.xmlElms));
                break;
            }
            case 4: {
                XmlCharacters elementChars = new XmlCharacters(streamReader.getText());
                this.xmlElms.add(elementChars);
                break;
            }
        }
    }
}

