/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.ocpjava.protocol.impl.core;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import io.netty.channel.nio.NioEventLoopGroup;
import org.opendaylight.ocpjava.protocol.api.connection.ConnectionConfiguration;
import org.opendaylight.ocpjava.protocol.api.connection.RadioHeadConnectionHandler;
import org.opendaylight.ocpjava.protocol.api.extensibility.DeserializerRegistry;
import org.opendaylight.ocpjava.protocol.api.extensibility.SerializerRegistry;
import org.opendaylight.ocpjava.protocol.impl.core.ChannelInitializerFactory;
import org.opendaylight.ocpjava.protocol.impl.core.ConnectionInitializer;
import org.opendaylight.ocpjava.protocol.impl.core.ServerFacade;
import org.opendaylight.ocpjava.protocol.impl.core.TcpChannelInitializer;
import org.opendaylight.ocpjava.protocol.impl.core.TcpConnectionInitializer;
import org.opendaylight.ocpjava.protocol.impl.core.TcpHandler;
import org.opendaylight.ocpjava.protocol.impl.deserialization.DeserializationFactory;
import org.opendaylight.ocpjava.protocol.impl.deserialization.DeserializerRegistryImpl;
import org.opendaylight.ocpjava.protocol.impl.serialization.SerializationFactory;
import org.opendaylight.ocpjava.protocol.impl.serialization.SerializerRegistryImpl;
import org.opendaylight.ocpjava.protocol.spi.connection.RadioHeadConnectionProvider;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.config.rev150811.TransportProtocol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RadioHeadConnectionProviderImpl
implements RadioHeadConnectionProvider,
ConnectionInitializer {
    private static final Logger LOGGER = LoggerFactory.getLogger(RadioHeadConnectionProviderImpl.class);
    private RadioHeadConnectionHandler radioHeadConnectionHandler;
    private ServerFacade serverFacade;
    private ConnectionConfiguration connConfig;
    private SerializationFactory serializationFactory;
    private SerializerRegistry serializerRegistry = new SerializerRegistryImpl();
    private DeserializerRegistry deserializerRegistry;
    private DeserializationFactory deserializationFactory;
    private TcpConnectionInitializer connectionInitializer;

    public RadioHeadConnectionProviderImpl() {
        this.serializerRegistry.init();
        this.serializationFactory = new SerializationFactory();
        this.serializationFactory.setSerializerTable(this.serializerRegistry);
        this.deserializerRegistry = new DeserializerRegistryImpl();
        this.deserializerRegistry.init();
        this.deserializationFactory = new DeserializationFactory();
        this.deserializationFactory.setRegistry(this.deserializerRegistry);
    }

    public void setConfiguration(ConnectionConfiguration connConfig) {
        this.connConfig = connConfig;
    }

    public void setRadioHeadConnectionHandler(RadioHeadConnectionHandler radioHeadConnectionHandler) {
        LOGGER.debug("setRadioHeadConnectionHandler");
        this.radioHeadConnectionHandler = radioHeadConnectionHandler;
    }

    public ListenableFuture<Boolean> shutdown() {
        LOGGER.debug("Shutdown summoned");
        if (this.serverFacade == null) {
            LOGGER.warn("Can not shutdown - not configured or started");
            throw new IllegalStateException("RadioHeadConnectionProvider is not started or not configured.");
        }
        return this.serverFacade.shutdown();
    }

    public ListenableFuture<Boolean> startup() {
        LOGGER.debug("Startup summoned");
        ListenableFuture<Boolean> result = null;
        try {
            this.serverFacade = this.createAndConfigureServer();
            if (this.radioHeadConnectionHandler == null) {
                throw new IllegalStateException("RadioHeadConnectionHandler is not set");
            }
            new Thread(this.serverFacade).start();
            result = this.serverFacade.getIsOnlineFuture();
        }
        catch (Exception e) {
            ListenableFuture<Boolean> exResult = SettableFuture.create();
            exResult.setException((Throwable)e);
            result = exResult;
        }
        return result;
    }

    private ServerFacade createAndConfigureServer() {
        LOGGER.debug("Configuring ..");
        TcpHandler server = null;
        ChannelInitializerFactory factory = new ChannelInitializerFactory();
        factory.setRadioHeadConnectionHandler(this.radioHeadConnectionHandler);
        factory.setRadioHeadIdleTimeout(this.connConfig.getRadioHeadIdleTimeout());
        factory.setTlsConfig(this.connConfig.getTlsConfiguration());
        factory.setSerializationFactory(this.serializationFactory);
        factory.setDeserializationFactory(this.deserializationFactory);
        TransportProtocol transportProtocol = (TransportProtocol)this.connConfig.getTransferProtocol();
        if (!transportProtocol.equals((Object)TransportProtocol.TCP) && !transportProtocol.equals((Object)TransportProtocol.TLS)) {
            throw new IllegalStateException("Unknown transport protocol received: " + transportProtocol);
        }
        server = new TcpHandler(this.connConfig.getAddress(), this.connConfig.getPort());
        TcpChannelInitializer channelInitializer = factory.createPublishingChannelInitializer();
        server.setChannelInitializer(channelInitializer);
        server.initiateEventLoopGroups(this.connConfig.getThreadConfiguration());
        NioEventLoopGroup workerGroupFromTcpHandler = server.getWorkerGroup();
        this.connectionInitializer = new TcpConnectionInitializer(workerGroupFromTcpHandler);
        this.connectionInitializer.setChannelInitializer(channelInitializer);
        this.connectionInitializer.run();
        server.setThreadConfig(this.connConfig.getThreadConfiguration());
        return server;
    }

    public ServerFacade getServerFacade() {
        return this.serverFacade;
    }

    public void close() throws Exception {
        this.shutdown();
    }

    @Override
    public void initiateConnection(String host, int port) {
        this.connectionInitializer.initiateConnection(host, port);
    }
}

