/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.ocpjava.protocol.impl.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.config.rev150811.PathType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SslKeyStore {
    private static final Logger LOGGER = LoggerFactory.getLogger(SslKeyStore.class);

    private SslKeyStore() {
        throw new UnsupportedOperationException("Utility class shouldn't be instantiated");
    }

    public static InputStream asInputStream(String filename, PathType pathType) {
        InputStream in;
        switch (pathType) {
            case CLASSPATH: {
                in = SslKeyStore.class.getResourceAsStream(filename);
                if (in != null) break;
                throw new IllegalStateException("KeyStore file not found: " + filename);
            }
            case PATH: {
                LOGGER.debug("Current dir using System:" + System.getProperty("user.dir"));
                File keystorefile = new File(filename);
                try {
                    in = new FileInputStream(keystorefile);
                    break;
                }
                catch (FileNotFoundException e) {
                    throw new IllegalStateException("KeyStore file not found: " + filename, e);
                }
            }
            default: {
                throw new IllegalArgumentException("Unknown path type: " + pathType);
            }
        }
        return in;
    }
}

