/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.ocpjava.protocol.impl.core;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.ssl.SslHandler;
import java.net.InetAddress;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLEngine;
import org.opendaylight.ocpjava.protocol.api.connection.ConnectionAdapter;
import org.opendaylight.ocpjava.protocol.impl.core.DelegatingInboundHandler;
import org.opendaylight.ocpjava.protocol.impl.core.IdleHandler;
import org.opendaylight.ocpjava.protocol.impl.core.OCPDecoder;
import org.opendaylight.ocpjava.protocol.impl.core.OCPEncoder;
import org.opendaylight.ocpjava.protocol.impl.core.OCPXmlDecoder;
import org.opendaylight.ocpjava.protocol.impl.core.PipelineHandlers;
import org.opendaylight.ocpjava.protocol.impl.core.ProtocolChannelInitializer;
import org.opendaylight.ocpjava.protocol.impl.core.SslContextFactory;
import org.opendaylight.ocpjava.protocol.impl.core.connection.ConnectionAdapterFactory;
import org.opendaylight.ocpjava.protocol.impl.core.connection.ConnectionAdapterFactoryImpl;
import org.opendaylight.ocpjava.protocol.impl.core.connection.ConnectionFacade;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TcpChannelInitializer
extends ProtocolChannelInitializer<SocketChannel> {
    private static final Logger LOGGER = LoggerFactory.getLogger(TcpChannelInitializer.class);
    private final DefaultChannelGroup allChannels;
    private ConnectionAdapterFactory connectionAdapterFactory;

    public TcpChannelInitializer() {
        this(new DefaultChannelGroup("netty-receiver", null), new ConnectionAdapterFactoryImpl());
    }

    protected TcpChannelInitializer(DefaultChannelGroup channelGroup, ConnectionAdapterFactory connAdaptorFactory) {
        this.allChannels = channelGroup;
        this.connectionAdapterFactory = connAdaptorFactory;
    }

    protected void initChannel(SocketChannel ch) {
        if (ch.remoteAddress() != null) {
            InetAddress radioHeadAddress = ch.remoteAddress().getAddress();
            int port = ch.localAddress().getPort();
            int remotePort = ch.remoteAddress().getPort();
            LOGGER.debug("Incoming connection from (remote address): {}:{} --> :{}", new Object[]{radioHeadAddress.toString(), remotePort, port});
            if (!this.getRadioHeadConnectionHandler().accept(radioHeadAddress)) {
                ch.disconnect();
                LOGGER.debug("Incoming connection rejected");
                return;
            }
        }
        LOGGER.debug("Incoming connection accepted - building pipeline");
        this.allChannels.add((Channel)ch);
        ConnectionFacade connectionFacade = null;
        connectionFacade = this.connectionAdapterFactory.createConnectionFacade((Channel)ch, null);
        try {
            LOGGER.trace("initChannel - getRadioHeadConnectionHandler: {}" + this.getRadioHeadConnectionHandler());
            this.getRadioHeadConnectionHandler().onRadioHeadConnected((ConnectionAdapter)connectionFacade);
            connectionFacade.checkListeners();
            ch.pipeline().addLast(PipelineHandlers.IDLE_HANDLER.name(), (ChannelHandler)new IdleHandler(this.getRadioHeadIdleTimeout(), TimeUnit.MILLISECONDS));
            boolean tlsPresent = false;
            if (this.getTlsConfiguration() != null) {
                tlsPresent = true;
                SslContextFactory sslFactory = new SslContextFactory(this.getTlsConfiguration());
                SSLEngine engine = sslFactory.getServerContext().createSSLEngine();
                engine.setNeedClientAuth(true);
                engine.setUseClientMode(false);
                ch.pipeline().addLast(PipelineHandlers.SSL_HANDLER.name(), (ChannelHandler)new SslHandler(engine));
            }
            ch.pipeline().addLast(PipelineHandlers.OCP_XML_DECODER.name(), (ChannelHandler)new OCPXmlDecoder(connectionFacade, tlsPresent));
            LOGGER.trace("TcpChannelInitializer - initChannel OCPXmlDecoder()");
            OCPDecoder ocpDecoder = new OCPDecoder();
            ocpDecoder.setDeserializationFactory(this.getDeserializationFactory());
            ch.pipeline().addLast(PipelineHandlers.OCP_DECODER.name(), (ChannelHandler)ocpDecoder);
            LOGGER.trace("TcpChannelInitializer - initChannel ocpDecoder()");
            OCPEncoder ocpEncoder = new OCPEncoder();
            ocpEncoder.setSerializationFactory(this.getSerializationFactory());
            ch.pipeline().addLast(PipelineHandlers.OCP_ENCODER.name(), (ChannelHandler)ocpEncoder);
            LOGGER.trace("TcpChannelInitializer - initChannel ocpEncoder()");
            ch.pipeline().addLast(PipelineHandlers.DELEGATING_INBOUND_HANDLER.name(), (ChannelHandler)new DelegatingInboundHandler(connectionFacade));
            LOGGER.trace("TcpChannelInitializer - initChannel DelegatingInboundHandler()");
            if (!tlsPresent) {
                connectionFacade.fireConnectionReadyNotification();
            }
            LOGGER.trace("TcpChannelInitializer - initChannel End");
        }
        catch (Exception e) {
            LOGGER.warn("Failed to initialize channel", (Throwable)e);
            ch.close();
        }
    }

    public Iterator<Channel> getConnectionIterator() {
        return this.allChannels.iterator();
    }

    public int size() {
        return this.allChannels.size();
    }
}

