/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.ocpjava.protocol.impl.core.connection;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import org.opendaylight.ocpjava.protocol.impl.core.connection.ChannelOutboundQueue;
import org.opendaylight.yangtools.yang.common.RpcError;
import org.opendaylight.yangtools.yang.common.RpcResult;
import org.opendaylight.yangtools.yang.common.RpcResultBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractRpcListener<T>
implements GenericFutureListener<Future<Void>>,
ChannelOutboundQueue.MessageHolder<Object> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractRpcListener.class);
    private static final String APPLICATION_TAG = "OCP_LIBRARY";
    private static final String TAG = "OCP";
    private final SettableFuture<RpcResult<T>> result = SettableFuture.create();
    private final String failureInfo;
    private Object message;

    static RpcError buildRpcError(String info, String message, Throwable cause) {
        return RpcResultBuilder.newError((RpcError.ErrorType)RpcError.ErrorType.RPC, (String)TAG, (String)message, (String)APPLICATION_TAG, (String)info, (Throwable)cause);
    }

    AbstractRpcListener(Object message, String failureInfo) {
        this.failureInfo = (String)Preconditions.checkNotNull((Object)failureInfo);
        this.message = Preconditions.checkNotNull((Object)message);
    }

    public final ListenableFuture<RpcResult<T>> getResult() {
        return this.result;
    }

    public final void operationComplete(Future<Void> future) {
        if (!future.isSuccess()) {
            LOG.debug("operation failed");
            this.failedRpc(future.cause());
        } else {
            LOG.debug("operation complete");
            this.operationSuccessful();
        }
    }

    @Override
    public final Object takeMessage() {
        Object ret = this.message;
        Preconditions.checkState((ret != null ? 1 : 0) != 0, (Object)"Message has already been taken");
        this.message = null;
        return ret;
    }

    @Override
    public final GenericFutureListener<Future<Void>> takeListener() {
        return this;
    }

    protected abstract void operationSuccessful();

    protected final void failedRpc(Throwable cause) {
        RpcError rpcError = AbstractRpcListener.buildRpcError(this.failureInfo, "check radioHead connection", cause);
        this.result.set((Object)RpcResultBuilder.failed().withRpcError(rpcError).build());
    }

    protected final void successfulRpc(T value) {
        this.result.set((Object)RpcResultBuilder.success(value).build());
    }
}

