/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.ocpjava.protocol.impl.core.connection;

import com.google.common.base.Preconditions;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalCause;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetSocketAddress;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import org.opendaylight.ocpjava.protocol.api.connection.ConnectionReadyListener;
import org.opendaylight.ocpjava.protocol.api.connection.OutboundQueueHandler;
import org.opendaylight.ocpjava.protocol.api.connection.OutboundQueueHandlerRegistration;
import org.opendaylight.ocpjava.protocol.impl.core.ChannelInitializerFactory;
import org.opendaylight.ocpjava.protocol.impl.core.connection.AbstractRpcListener;
import org.opendaylight.ocpjava.protocol.impl.core.connection.ChannelOutboundQueue;
import org.opendaylight.ocpjava.protocol.impl.core.connection.ConnectionFacade;
import org.opendaylight.ocpjava.protocol.impl.core.connection.OutboundQueueHandlerRegistrationImpl;
import org.opendaylight.ocpjava.protocol.impl.core.connection.OutboundQueueManager;
import org.opendaylight.ocpjava.protocol.impl.core.connection.ResponseExpectedRpcListener;
import org.opendaylight.ocpjava.protocol.impl.core.connection.RpcResponseKey;
import org.opendaylight.ocpjava.protocol.impl.core.connection.SimpleRpcListener;
import org.opendaylight.ocpjava.statistics.CounterEventTypes;
import org.opendaylight.ocpjava.statistics.OcpStatisticsCounters;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.OcpHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.extension.rev150811.HelloInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.extension.rev150811.HelloMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.extension.rev150811.OcpExtensionListener;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.extension.rev150811.ReDirectInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.extension.rev150811.ReDirectOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.protocol.rev150811.CreateObjInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.protocol.rev150811.CreateObjOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.protocol.rev150811.DeleteObjInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.protocol.rev150811.DeleteObjOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.protocol.rev150811.FaultInd;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.protocol.rev150811.GetFaultInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.protocol.rev150811.GetFaultOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.protocol.rev150811.GetParamInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.protocol.rev150811.GetParamOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.protocol.rev150811.GetStateInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.protocol.rev150811.GetStateOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.protocol.rev150811.HealthCheckInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.protocol.rev150811.HealthCheckOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.protocol.rev150811.ModifyParamInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.protocol.rev150811.ModifyParamOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.protocol.rev150811.ModifyStateInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.protocol.rev150811.ModifyStateOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.protocol.rev150811.OcpProtocolListener;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.protocol.rev150811.ReResetInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.protocol.rev150811.ReResetOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.protocol.rev150811.SetTimeInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.protocol.rev150811.SetTimeOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.protocol.rev150811.StateChangeInd;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.system.rev150811.DisconnectEvent;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.system.rev150811.RadioHeadIdleEvent;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.system.rev150811.SystemNotificationsListener;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.Notification;
import org.opendaylight.yangtools.yang.common.RpcResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionAdapterImpl
implements ConnectionFacade {
    public static final int RPC_RESPONSE_EXPIRATION = 1;
    public static final int DEFAULT_QUEUE_DEPTH = 1024;
    private static final Logger LOG = LoggerFactory.getLogger(ConnectionAdapterImpl.class);
    private static final Exception QUEUE_FULL_EXCEPTION = new RejectedExecutionException("Output queue is full");
    private static final RemovalListener<RpcResponseKey, ResponseExpectedRpcListener<?>> REMOVAL_LISTENER = new RemovalListener<RpcResponseKey, ResponseExpectedRpcListener<?>>(){

        public void onRemoval(RemovalNotification<RpcResponseKey, ResponseExpectedRpcListener<?>> notification) {
            if (!notification.getCause().equals((Object)RemovalCause.EXPLICIT)) {
                ((ResponseExpectedRpcListener)notification.getValue()).discard();
            }
        }
    };
    private Cache<RpcResponseKey, ResponseExpectedRpcListener<?>> responseCache = CacheBuilder.newBuilder().concurrencyLevel(1).expireAfterWrite(1L, TimeUnit.MINUTES).removalListener(REMOVAL_LISTENER).build();
    private final ChannelOutboundQueue output;
    private final Channel channel;
    private SystemNotificationsListener systemListener;
    private OcpProtocolListener messageListener;
    private OcpExtensionListener messageExtListener;
    private ConnectionReadyListener connectionReadyListener;
    private OutboundQueueManager<?> outputManager;
    private boolean disconnectOccured = false;
    private final OcpStatisticsCounters statisticsCounters;
    private final InetSocketAddress address;

    public ConnectionAdapterImpl(Channel channel, InetSocketAddress address) {
        this.channel = (Channel)Preconditions.checkNotNull((Object)channel);
        this.output = new ChannelOutboundQueue(channel, 1024, address);
        this.address = address;
        channel.pipeline().addLast(new ChannelHandler[]{this.output});
        this.statisticsCounters = OcpStatisticsCounters.getInstance();
        LOG.debug("ConnectionAdapter created");
    }

    public java.util.concurrent.Future<RpcResult<HealthCheckOutput>> healthCheck(HealthCheckInput input) {
        return this.sendToRadioHeadExpectRpcResultFuture(input, HealthCheckOutput.class, "health-check-input sending failed");
    }

    public java.util.concurrent.Future<RpcResult<SetTimeOutput>> setTime(SetTimeInput input) {
        return this.sendToRadioHeadExpectRpcResultFuture(input, SetTimeOutput.class, "set-time-input sending failed");
    }

    public java.util.concurrent.Future<RpcResult<ReResetOutput>> reReset(ReResetInput input) {
        return this.sendToRadioHeadExpectRpcResultFuture(input, ReResetOutput.class, "re-reset-input sending failed");
    }

    public java.util.concurrent.Future<RpcResult<GetParamOutput>> getParam(GetParamInput input) {
        return this.sendToRadioHeadExpectRpcResultFuture(input, GetParamOutput.class, "get-param-input sending failed");
    }

    public java.util.concurrent.Future<RpcResult<ModifyParamOutput>> modifyParam(ModifyParamInput input) {
        return this.sendToRadioHeadExpectRpcResultFuture(input, ModifyParamOutput.class, "modify-param-input sending failed");
    }

    public java.util.concurrent.Future<RpcResult<CreateObjOutput>> createObj(CreateObjInput input) {
        return this.sendToRadioHeadExpectRpcResultFuture(input, CreateObjOutput.class, "create-obj-input sending failed");
    }

    public java.util.concurrent.Future<RpcResult<DeleteObjOutput>> deleteObj(DeleteObjInput input) {
        return this.sendToRadioHeadExpectRpcResultFuture(input, DeleteObjOutput.class, "delete-object-input sending failed");
    }

    public java.util.concurrent.Future<RpcResult<GetStateOutput>> getState(GetStateInput input) {
        return this.sendToRadioHeadExpectRpcResultFuture(input, GetStateOutput.class, "get-state-input sending failed");
    }

    public java.util.concurrent.Future<RpcResult<ModifyStateOutput>> modifyState(ModifyStateInput input) {
        return this.sendToRadioHeadExpectRpcResultFuture(input, ModifyStateOutput.class, "modify-state-input sending failed");
    }

    public java.util.concurrent.Future<RpcResult<GetFaultOutput>> getFault(GetFaultInput input) {
        return this.sendToRadioHeadExpectRpcResultFuture(input, GetFaultOutput.class, "get-fault-input sending failed");
    }

    public java.util.concurrent.Future<RpcResult<ReDirectOutput>> reDirect(ReDirectInput input) {
        return this.sendToRadioHeadExpectRpcResultFuture(input, ReDirectOutput.class, "redirect-input sending failed");
    }

    public java.util.concurrent.Future<RpcResult<Void>> hello(HelloInput input) {
        return this.sendToRadioHeadFuture((DataObject)input, "hello-ack sending failed");
    }

    public java.util.concurrent.Future<Boolean> disconnect() {
        ChannelFuture disconnectResult = this.channel.disconnect();
        this.responseCache.invalidateAll();
        this.disconnectOccured = true;
        return ConnectionAdapterImpl.handleTransportChannelFuture(disconnectResult);
    }

    public boolean isAlive() {
        return this.channel.isOpen();
    }

    public void setMessageListener(OcpProtocolListener messageListener) {
        this.messageListener = messageListener;
    }

    public void setMessageExtListener(OcpExtensionListener messageExtListener) {
        this.messageExtListener = messageExtListener;
    }

    @Override
    public void consume(DataObject message) {
        LOG.debug("ConsumeIntern msg on {}", (Object)this.channel);
        if (this.disconnectOccured) {
            return;
        }
        if (message instanceof Notification) {
            if (message instanceof DisconnectEvent) {
                this.systemListener.onDisconnectEvent((DisconnectEvent)message);
                this.responseCache.invalidateAll();
                this.disconnectOccured = true;
            } else if (message instanceof RadioHeadIdleEvent) {
                this.systemListener.onRadioHeadIdleEvent((RadioHeadIdleEvent)message);
            } else if (message instanceof StateChangeInd) {
                LOG.info("StateChangeInd received / branch");
                this.messageListener.onStateChangeInd((StateChangeInd)message);
                this.statisticsCounters.incrementCounter(CounterEventTypes.US_MESSAGE_PASS);
            } else if (message instanceof FaultInd) {
                LOG.info("FaultInd received / branch");
                this.messageListener.onFaultInd((FaultInd)message);
                this.statisticsCounters.incrementCounter(CounterEventTypes.US_MESSAGE_PASS);
            } else if (message instanceof HelloMessage) {
                LOG.info("Hello received / branch");
                this.messageExtListener.onHelloMessage((HelloMessage)message);
                this.statisticsCounters.incrementCounter(CounterEventTypes.US_MESSAGE_PASS);
            } else {
                LOG.warn("message listening not supported for type: {}", message.getClass());
            }
        } else if (message instanceof OcpHeader) {
            LOG.debug("OCPheader msg received");
            if (this.outputManager == null || !this.outputManager.onMessage((OcpHeader)message)) {
                RpcResponseKey key = ConnectionAdapterImpl.createRpcResponseKey((OcpHeader)message);
                ResponseExpectedRpcListener<?> listener = this.findRpcResponse(key);
                if (listener != null) {
                    LOG.debug("corresponding rpcFuture found");
                    listener.completed((OcpHeader)message);
                    this.statisticsCounters.incrementCounter(CounterEventTypes.US_MESSAGE_PASS);
                    LOG.debug("after setting rpcFuture");
                    this.responseCache.invalidate((Object)key);
                } else {
                    LOG.warn("received unexpected rpc response: {}", (Object)key);
                }
            }
        } else {
            LOG.warn("message listening not supported for type: {}", message.getClass());
        }
    }

    private <T> ListenableFuture<RpcResult<T>> enqueueMessage(AbstractRpcListener<T> promise) {
        LOG.debug("Submitting promise {}", promise);
        if (!this.output.enqueue(promise)) {
            LOG.debug("Message queue is full, rejecting execution");
            promise.failedRpc(QUEUE_FULL_EXCEPTION);
        } else {
            LOG.debug("Promise enqueued successfully");
        }
        return promise.getResult();
    }

    private ListenableFuture<RpcResult<Void>> sendToRadioHeadFuture(DataObject input, String failureInfo) {
        this.statisticsCounters.incrementCounter(CounterEventTypes.DS_ENTERED_OCPJAVA);
        return this.enqueueMessage(new SimpleRpcListener(input, failureInfo));
    }

    private <IN extends OcpHeader, OUT extends OcpHeader> ListenableFuture<RpcResult<OUT>> sendToRadioHeadExpectRpcResultFuture(IN input, Class<OUT> responseClazz, String failureInfo) {
        RpcResponseKey key = new RpcResponseKey(input.getXid(), responseClazz.getName());
        ResponseExpectedRpcListener listener = new ResponseExpectedRpcListener(input, failureInfo, this.responseCache, key);
        this.statisticsCounters.incrementCounter(CounterEventTypes.DS_ENTERED_OCPJAVA);
        return this.enqueueMessage(listener);
    }

    private static SettableFuture<Boolean> handleTransportChannelFuture(ChannelFuture resultFuture) {
        final SettableFuture transportResult = SettableFuture.create();
        resultFuture.addListener((GenericFutureListener)new GenericFutureListener<Future<? super Void>>(){

            public void operationComplete(Future<? super Void> future) throws Exception {
                transportResult.set((Object)future.isSuccess());
                if (!future.isSuccess()) {
                    transportResult.setException(future.cause());
                }
            }
        });
        return transportResult;
    }

    private static RpcResponseKey createRpcResponseKey(OcpHeader message) {
        return new RpcResponseKey(message.getXid(), message.getImplementedInterface().getName());
    }

    private ResponseExpectedRpcListener<?> findRpcResponse(RpcResponseKey key) {
        return (ResponseExpectedRpcListener)this.responseCache.getIfPresent((Object)key);
    }

    public void setSystemListener(SystemNotificationsListener systemListener) {
        this.systemListener = systemListener;
    }

    public void checkListeners() {
        StringBuilder buffer = new StringBuilder();
        if (this.systemListener == null) {
            buffer.append("SystemListener ");
        }
        if (this.messageListener == null) {
            buffer.append("MessageListener ");
        }
        if (this.messageExtListener == null) {
            buffer.append("MessageExtListener ");
        }
        if (this.connectionReadyListener == null) {
            buffer.append("ConnectionReadyListener ");
        }
        Preconditions.checkState((buffer.length() == 0 ? 1 : 0) != 0, (String)"Missing listeners: %s", (Object[])new Object[]{buffer.toString()});
    }

    public void fireConnectionReadyNotification() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ConnectionAdapterImpl.this.connectionReadyListener.onConnectionReady();
            }
        }).start();
    }

    public void setConnectionReadyListener(ConnectionReadyListener connectionReadyListener) {
        this.connectionReadyListener = connectionReadyListener;
    }

    public InetSocketAddress getRemoteAddress() {
        return (InetSocketAddress)this.channel.remoteAddress();
    }

    public void setResponseCache(Cache<RpcResponseKey, ResponseExpectedRpcListener<?>> cache) {
        this.responseCache = cache;
    }

    public boolean isAutoRead() {
        return this.channel.config().isAutoRead();
    }

    public void setAutoRead(boolean autoRead) {
        this.channel.config().setAutoRead(autoRead);
    }

    public void setIdleTimeout(long idleTimeout) {
        ChannelInitializerFactory channelInitializerFactory = new ChannelInitializerFactory();
        channelInitializerFactory.setRadioHeadIdleTimeout(idleTimeout);
    }

    public <T extends OutboundQueueHandler> OutboundQueueHandlerRegistration<T> registerOutboundQueueHandler(T handler, int maxQueueDepth) {
        Preconditions.checkState((this.outputManager == null ? 1 : 0) != 0, (String)"Manager %s already registered", (Object[])new Object[]{this.outputManager});
        OutboundQueueManager<T> ret = new OutboundQueueManager<T>(this, this.address, handler, maxQueueDepth);
        this.outputManager = ret;
        this.channel.pipeline().addLast(new ChannelHandler[]{this.outputManager});
        return new OutboundQueueHandlerRegistrationImpl<T>(handler){

            protected void removeRegistration() {
                ConnectionAdapterImpl.this.outputManager.close();
                ConnectionAdapterImpl.this.channel.pipeline().remove((ChannelHandler)ConnectionAdapterImpl.this.outputManager);
                ConnectionAdapterImpl.this.outputManager = null;
            }
        };
    }

    Channel getChannel() {
        return this.channel;
    }
}

