/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.ocpjava.protocol.impl.core.connection;

import com.google.common.base.Preconditions;
import com.google.common.cache.Cache;
import java.util.concurrent.TimeoutException;
import org.opendaylight.ocpjava.protocol.impl.core.connection.AbstractRpcListener;
import org.opendaylight.ocpjava.protocol.impl.core.connection.RpcResponseKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.OcpHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ResponseExpectedRpcListener<T extends OcpHeader>
extends AbstractRpcListener<T> {
    private static final Logger LOG = LoggerFactory.getLogger(ResponseExpectedRpcListener.class);
    private final Cache<RpcResponseKey, ResponseExpectedRpcListener<?>> cache;
    private final RpcResponseKey key;

    ResponseExpectedRpcListener(Object message, String failureInfo, Cache<RpcResponseKey, ResponseExpectedRpcListener<?>> cache, RpcResponseKey key) {
        super(message, failureInfo);
        this.cache = (Cache)Preconditions.checkNotNull(cache);
        this.key = (RpcResponseKey)Preconditions.checkNotNull((Object)key);
    }

    public void discard() {
        LOG.warn("Request for {} did not receive a response", (Object)this.key);
        this.failedRpc(new TimeoutException("Request timed out"));
    }

    public void completed(OcpHeader message) {
        this.successfulRpc(message);
    }

    public void ocpcompleted(OcpHeader message) {
        this.successfulRpc(message);
    }

    @Override
    protected void operationSuccessful() {
        LOG.debug("Request for {} sent successfully", (Object)this.key);
        this.cache.put((Object)this.key, (Object)this);
    }
}

