/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.ocpjava.protocol.impl.core.connection;

import com.google.common.base.FinalizableReferenceQueue;
import com.google.common.base.FinalizableSoftReference;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.lang.ref.Reference;
import java.util.concurrent.ConcurrentLinkedDeque;
import org.opendaylight.ocpjava.protocol.api.connection.OutboundQueueException;
import org.opendaylight.ocpjava.protocol.impl.core.connection.OutboundQueueEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.OcpHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class StackedSegment {
    static final int SEGMENT_SIZE = 4096;
    private static final Logger LOG = LoggerFactory.getLogger(StackedSegment.class);
    private static final FinalizableReferenceQueue REF_QUEUE = new FinalizableReferenceQueue();
    private static final ConcurrentLinkedDeque<QueueRef> CACHE = new ConcurrentLinkedDeque();
    private final OutboundQueueEntry[] entries;
    private final long baseXid;
    private final long endXid;
    private int lastBarrierOffset = -1;
    private int completeCount;

    StackedSegment(long baseXid, OutboundQueueEntry[] entries) {
        this.baseXid = baseXid;
        this.endXid = baseXid + 4096L;
        this.entries = (OutboundQueueEntry[])Preconditions.checkNotNull((Object)entries);
    }

    static StackedSegment create(long baseXid) {
        Reference item;
        while ((item = (Reference)((Object)CACHE.pollLast())) != null) {
            OutboundQueueEntry[] cached = (OutboundQueueEntry[])item.get();
            if (cached == null) continue;
            StackedSegment ret = new StackedSegment(baseXid, cached);
            LOG.trace("Reusing array {} in segment {}", (Object)cached, (Object)ret);
            return ret;
        }
        OutboundQueueEntry[] entries = new OutboundQueueEntry[4096];
        for (int i = 0; i < 4096; ++i) {
            entries[i] = new OutboundQueueEntry();
        }
        StackedSegment ret = new StackedSegment(baseXid, entries);
        LOG.trace("Allocated new segment {}", (Object)ret);
        return ret;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("baseXid", this.baseXid).add("endXid", this.endXid).add("completeCount", this.completeCount).toString();
    }

    long getBaseXid() {
        return this.baseXid;
    }

    long getEndXid() {
        return this.endXid;
    }

    OutboundQueueEntry getEntry(int offset) {
        return this.entries[offset];
    }

    private boolean xidInRange(long xid) {
        return xid < this.endXid && (xid >= this.baseXid || this.baseXid > this.endXid);
    }

    private static boolean completeEntry(OutboundQueueEntry entry, OcpHeader response) {
        return entry.complete(response);
    }

    OutboundQueueEntry pairRequest(OcpHeader response) {
        long xid = response.getXid();
        if (!this.xidInRange(xid)) {
            LOG.debug("Queue {} {}/{} ignoring XID {}", new Object[]{this, this.baseXid, this.entries.length, xid});
            return null;
        }
        int offset = (int)(xid - this.baseXid);
        OutboundQueueEntry entry = this.entries[offset];
        if (entry.isCompleted()) {
            LOG.debug("Entry {} already is completed, not accepting response {}", (Object)entry, (Object)response);
            return null;
        }
        if (StackedSegment.completeEntry(entry, response)) {
            ++this.completeCount;
        }
        return entry;
    }

    private void completeRequests(int toOffset) {
        for (int i = this.lastBarrierOffset + 1; i < toOffset; ++i) {
            OutboundQueueEntry entry = this.entries[i];
            if (entry.isCompleted() || !entry.complete(null)) continue;
            ++this.completeCount;
        }
    }

    void completeAll() {
        this.completeRequests(this.entries.length);
    }

    int failAll(OutboundQueueException cause) {
        OutboundQueueEntry entry;
        int ret = 0;
        for (int i = this.lastBarrierOffset + 1; i < this.entries.length && (entry = this.entries[i]).isCommitted(); ++i) {
            if (entry.isCompleted()) continue;
            entry.fail(cause);
            ++ret;
        }
        return ret;
    }

    boolean isComplete() {
        return this.completeCount >= this.entries.length;
    }

    void recycle() {
        for (OutboundQueueEntry e : this.entries) {
            e.reset();
        }
        CACHE.offer(new QueueRef(REF_QUEUE, this.entries));
    }

    private static final class QueueRef
    extends FinalizableSoftReference<OutboundQueueEntry[]> {
        QueueRef(FinalizableReferenceQueue queue, OutboundQueueEntry[] referent) {
            super((Object)referent, queue);
        }

        public void finalizeReferent() {
            CACHE.remove((Object)this);
        }
    }
}

