/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.ocpjava.protocol.impl.deserialization;

import java.util.HashMap;
import java.util.Map;
import org.opendaylight.ocpjava.protocol.api.extensibility.DeserializerRegistry;
import org.opendaylight.ocpjava.protocol.api.extensibility.DeserializerRegistryInjector;
import org.opendaylight.ocpjava.protocol.api.extensibility.OCPGeneralDeserializer;
import org.opendaylight.ocpjava.protocol.api.keys.MessageCodeKey;
import org.opendaylight.ocpjava.protocol.impl.deserialization.MessageDeserializerInitializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeserializerRegistryImpl
implements DeserializerRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(DeserializerRegistryImpl.class);
    private Map<MessageCodeKey, OCPGeneralDeserializer> registry;

    public void init() {
        this.registry = new HashMap<MessageCodeKey, OCPGeneralDeserializer>();
        MessageDeserializerInitializer.registerMessageDeserializers(this);
    }

    public <T extends OCPGeneralDeserializer> T getDeserializer(MessageCodeKey key) {
        LOGGER.trace("DeserializerRegistryImpl - getDeserializer: key = " + key.toString());
        OCPGeneralDeserializer deserializer = this.registry.get(key);
        if (deserializer == null) {
            throw new IllegalStateException("Deserializer for key: " + key + " was not found - please verify that all needed deserializers ale loaded correctly");
        }
        return (T)deserializer;
    }

    public void registerDeserializer(MessageCodeKey key, OCPGeneralDeserializer deserializer) {
        if (key == null || deserializer == null) {
            throw new IllegalArgumentException("MessageCodeKey or Deserializer is null");
        }
        OCPGeneralDeserializer desInRegistry = this.registry.put(key, deserializer);
        if (desInRegistry != null) {
            LOGGER.debug("Deserializer for key {} overwritten. Old deserializer: {}, new deserializer: {}", new Object[]{key, desInRegistry.getClass().getName(), deserializer.getClass().getName()});
        }
        if (deserializer instanceof DeserializerRegistryInjector) {
            ((DeserializerRegistryInjector)deserializer).injectDeserializerRegistry((DeserializerRegistry)this);
        }
    }

    public boolean unregisterDeserializer(MessageCodeKey key) {
        if (key == null) {
            throw new IllegalArgumentException("MessageCodeKey is null");
        }
        OCPGeneralDeserializer deserializer = this.registry.remove(key);
        return deserializer != null;
    }
}

