/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.ocpjava.protocol.impl.deserialization.factories;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.opendaylight.ocpjava.protocol.api.extensibility.OCPDeserializer;
import org.opendaylight.ocpjava.protocol.impl.core.XmlCharacters;
import org.opendaylight.ocpjava.protocol.impl.core.XmlElementEnd;
import org.opendaylight.ocpjava.protocol.impl.core.XmlElementStart;
import org.opendaylight.ocpjava.protocol.impl.deserialization.factories.utils.MessageHelper;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.FaultId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.FaultSeverity;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.FaultState;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.ObjId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.OcpMsgType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.protocol.rev150811.FaultInd;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.protocol.rev150811.FaultIndBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.xsd.types.rev150811.XsdDateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FaultIndFactory
implements OCPDeserializer<FaultInd> {
    private static final Logger LOGGER = LoggerFactory.getLogger(FaultIndFactory.class);
    private String faultTag = "fault";

    public FaultInd deserialize(List<Object> rawMessage) {
        FaultIndBuilder builder = new FaultIndBuilder();
        Iterator<Object> itr = rawMessage.iterator();
        while (itr.hasNext()) {
            Object tok = itr.next();
            LOGGER.trace("FaultIndFactory - itr = " + tok);
            try {
                if (!(tok instanceof XmlElementStart)) continue;
                if (((XmlElementStart)tok).name().equals("body")) {
                    String type = MessageHelper.getMsgType(itr);
                    builder.setMsgType(OcpMsgType.valueOf((String)type));
                    continue;
                }
                if (((XmlElementStart)tok).name().equals("msgUID")) {
                    String uidStr = MessageHelper.getMsgUID(itr);
                    int uid = Integer.parseInt(uidStr);
                    builder.setXid(Long.valueOf(uid));
                    continue;
                }
                if (!((XmlElementStart)tok).name().equals("obj")) continue;
                builder.setObjId(new ObjId(((XmlElementStart)tok).attributes().get(0).value()));
                LOGGER.debug("FaultIndFactory - builder getObjId: " + builder.getObjId());
                tok = itr.next();
                while (!(tok instanceof XmlElementStart)) {
                    tok = itr.next();
                }
                if (!((XmlElementStart)tok).name().equals(this.faultTag)) continue;
                itr.next();
                Object faultTok = itr.next();
                ArrayList<String> afftok = new ArrayList<String>();
                while (!((XmlElementStart)faultTok).name().equals(this.faultTag)) {
                    String bufStr;
                    if (((XmlElementStart)faultTok).name().equals("faultID")) {
                        bufStr = MessageHelper.getCharVal(itr);
                        builder.setFaultId(FaultId.valueOf((String)bufStr));
                    } else if (((XmlElementStart)faultTok).name().equals("state")) {
                        bufStr = MessageHelper.getCharVal(itr);
                        builder.setState(FaultState.valueOf((String)bufStr));
                    } else if (((XmlElementStart)faultTok).name().equals("severity")) {
                        bufStr = MessageHelper.getCharVal(itr);
                        builder.setSeverity(FaultSeverity.valueOf((String)bufStr));
                    } else if (((XmlElementStart)faultTok).name().equals("timestamp")) {
                        bufStr = MessageHelper.getCharVal(itr);
                        builder.setTimestamp(new XsdDateTime(bufStr));
                    } else if (((XmlElementStart)faultTok).name().equals("descr")) {
                        faultTok = itr.next();
                        StringBuilder buf = new StringBuilder();
                        while (faultTok instanceof XmlCharacters) {
                            buf.append(((XmlCharacters)faultTok).data().toString());
                            faultTok = itr.next();
                        }
                        builder.setDescr(buf.toString());
                    } else if (((XmlElementStart)faultTok).name().equals("affectedObj")) {
                        bufStr = MessageHelper.getCharVal(itr);
                        afftok.add(bufStr);
                        builder.setAffectedObj(afftok);
                    } else {
                        faultTok = itr.next();
                        while (faultTok instanceof XmlCharacters) {
                            faultTok = itr.next();
                        }
                    }
                    faultTok = itr.next();
                    while (!(faultTok instanceof XmlElementStart || faultTok instanceof XmlElementEnd && ((XmlElementEnd)faultTok).name().equals(this.faultTag))) {
                        faultTok = itr.next();
                    }
                    if (!(faultTok instanceof XmlElementEnd) || !((XmlElementEnd)faultTok).name().equals(this.faultTag)) continue;
                }
                builder.setAffectedObj(afftok);
            }
            catch (Exception t) {
                LOGGER.error("Error " + tok + " " + t.toString());
            }
        }
        LOGGER.debug("FaultIndFactory - Builder: " + builder.build());
        return builder.build();
    }
}

