/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.ocpjava.protocol.impl.deserialization.factories;

import java.util.Iterator;
import java.util.List;
import org.opendaylight.ocpjava.protocol.api.extensibility.OCPDeserializer;
import org.opendaylight.ocpjava.protocol.impl.core.XmlElementStart;
import org.opendaylight.ocpjava.protocol.impl.deserialization.factories.utils.MessageHelper;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.OcpMsgType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.OriRes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.protocol.rev150811.HealthCheckOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.protocol.rev150811.HealthCheckOutputBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HealthCheckOutputFactory
implements OCPDeserializer<HealthCheckOutput> {
    private static final Logger LOGGER = LoggerFactory.getLogger(HealthCheckOutputFactory.class);

    public HealthCheckOutput deserialize(List<Object> rawMessage) {
        HealthCheckOutputBuilder builder = new HealthCheckOutputBuilder();
        Iterator<Object> itr = rawMessage.iterator();
        while (itr.hasNext()) {
            Object tok = itr.next();
            LOGGER.trace("HealthCheckOutputFactory - itr = " + tok);
            try {
                if (!(tok instanceof XmlElementStart)) continue;
                if (((XmlElementStart)tok).name().equals("body")) {
                    String type = MessageHelper.getMsgType(itr);
                    builder.setMsgType(OcpMsgType.valueOf((String)type));
                    continue;
                }
                if (((XmlElementStart)tok).name().equals("msgUID")) {
                    String uidStr = MessageHelper.getMsgUID(itr);
                    int uid = Integer.parseInt(uidStr);
                    builder.setXid(Long.valueOf(uid));
                    continue;
                }
                if (!((XmlElementStart)tok).name().equals("result")) continue;
                String rel = MessageHelper.getResult(itr);
                builder.setResult(OriRes.valueOf((String)rel));
            }
            catch (Exception t) {
                LOGGER.error("Error " + tok + " " + t.toString());
            }
        }
        LOGGER.debug("HealthCheckOutputFactory - Builder: " + builder.build());
        return builder.build();
    }
}

