/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.ocpjava.protocol.impl.deserialization.factories;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.opendaylight.ocpjava.protocol.api.extensibility.OCPDeserializer;
import org.opendaylight.ocpjava.protocol.impl.core.XmlCharacters;
import org.opendaylight.ocpjava.protocol.impl.core.XmlElementEnd;
import org.opendaylight.ocpjava.protocol.impl.core.XmlElementStart;
import org.opendaylight.ocpjava.protocol.impl.deserialization.factories.utils.MessageHelper;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.ModifyParamGlobRes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.ModifyParamRes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.ObjId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.OcpMsgType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.modifyparamoutput.Param;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.modifyparamoutput.ParamBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.protocol.rev150811.ModifyParamOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.protocol.rev150811.ModifyParamOutputBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModifyParamOutputFactory
implements OCPDeserializer<ModifyParamOutput> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ModifyParamOutputFactory.class);

    public ModifyParamOutput deserialize(List<Object> rawMessage) {
        ModifyParamOutputBuilder builder = new ModifyParamOutputBuilder();
        ParamBuilder parambuilder = new ParamBuilder();
        ArrayList<Param> paramlist = new ArrayList<Param>();
        Iterator<Object> itr = rawMessage.iterator();
        while (itr.hasNext()) {
            Object tok = itr.next();
            LOGGER.trace("ModifyParamOutputFactory - itr = " + tok);
            try {
                if (!(tok instanceof XmlElementStart)) continue;
                if (((XmlElementStart)tok).name().equals("body")) {
                    String type = MessageHelper.getMsgType(itr);
                    builder.setMsgType(OcpMsgType.valueOf((String)type));
                    continue;
                }
                if (((XmlElementStart)tok).name().equals("msgUID")) {
                    String uidStr = MessageHelper.getMsgUID(itr);
                    int uid = Integer.parseInt(uidStr);
                    builder.setXid(Long.valueOf(uid));
                    continue;
                }
                if (((XmlElementStart)tok).name().equals("globResult")) {
                    String globRel = MessageHelper.getResult(itr);
                    builder.setGlobResult(ModifyParamGlobRes.valueOf((String)globRel));
                    continue;
                }
                if (!((XmlElementStart)tok).name().equals("obj")) continue;
                if (((XmlElementStart)tok).attributes().size() >= 1) {
                    builder.setObjId(new ObjId(((XmlElementStart)tok).attributes().get(0).value()));
                }
                LOGGER.debug("ModifyParamOutputFactory - getObjId = " + builder.getObjId());
                tok = itr.next();
                while (!(tok instanceof XmlElementStart)) {
                    tok = itr.next();
                }
                while (!((XmlElementStart)tok).name().equals("obj")) {
                    if (!((XmlElementStart)tok).name().equals("param")) continue;
                    parambuilder.setName(((XmlElementStart)tok).attributes().get(0).value());
                    LOGGER.debug("ModifyParamOutputFactory - getName = " + parambuilder.getName());
                    Object nexttok = itr.next();
                    while (!(nexttok instanceof XmlElementStart)) {
                        nexttok = itr.next();
                    }
                    if (((XmlElementStart)nexttok).name().equals("result")) {
                        String rel = MessageHelper.getResult(itr);
                        parambuilder.setResult(ModifyParamRes.valueOf((String)rel));
                    }
                    paramlist.add(parambuilder.build());
                    parambuilder = new ParamBuilder();
                    tok = itr.next();
                    while (!(!(tok instanceof XmlElementStart) && !(tok instanceof XmlElementEnd) && !(tok instanceof XmlCharacters) || tok instanceof XmlElementStart && ((XmlElementStart)tok).name().equals("param") || tok instanceof XmlElementEnd && ((XmlElementEnd)tok).name().equals("obj"))) {
                        tok = itr.next();
                    }
                    if (!(tok instanceof XmlElementEnd) || !((XmlElementEnd)tok).name().equals("obj")) continue;
                    break;
                }
                builder.setParam(paramlist);
                paramlist = new ArrayList();
                LOGGER.trace("ModifyParamOutputFactory - builder.getParam() = " + builder.getParam());
            }
            catch (Exception t) {
                LOGGER.error("Error " + tok + " " + t.toString());
            }
        }
        LOGGER.info("ModifyParamOutputFactory - Builder: " + builder.build());
        return builder.build();
    }
}

