/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.ocpjava.protocol.impl.deserialization.factories;

import java.util.Iterator;
import java.util.List;
import org.opendaylight.ocpjava.protocol.api.extensibility.OCPDeserializer;
import org.opendaylight.ocpjava.protocol.impl.core.XmlCharacters;
import org.opendaylight.ocpjava.protocol.impl.core.XmlElementEnd;
import org.opendaylight.ocpjava.protocol.impl.core.XmlElementStart;
import org.opendaylight.ocpjava.protocol.impl.deserialization.factories.utils.MessageHelper;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.ModifyStateRes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.ObjId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.OcpMsgType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.StateType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.StateVal;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.protocol.rev150811.ModifyStateOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.protocol.rev150811.ModifyStateOutputBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModifyStateOutputFactory
implements OCPDeserializer<ModifyStateOutput> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ModifyStateOutputFactory.class);

    public ModifyStateOutput deserialize(List<Object> rawMessage) {
        ModifyStateOutputBuilder builder = new ModifyStateOutputBuilder();
        Iterator<Object> itr = rawMessage.iterator();
        while (itr.hasNext()) {
            Object tok = itr.next();
            LOGGER.trace("ModifyStateOutputFactory - itr = " + tok);
            try {
                if (!(tok instanceof XmlElementStart)) continue;
                if (((XmlElementStart)tok).name().equals("body")) {
                    String type = MessageHelper.getMsgType(itr);
                    builder.setMsgType(OcpMsgType.valueOf((String)type));
                }
                if (((XmlElementStart)tok).name().equals("msgUID")) {
                    String uidStr = MessageHelper.getMsgUID(itr);
                    int uid = Integer.parseInt(uidStr);
                    builder.setXid(Long.valueOf(uid));
                }
                if (((XmlElementStart)tok).name().equals("result")) {
                    String rel = MessageHelper.getResult(itr);
                    builder.setResult(ModifyStateRes.valueOf((String)rel));
                }
                if (!((XmlElementStart)tok).name().equals("obj")) continue;
                builder.setObjId(new ObjId(((XmlElementStart)tok).attributes().get(0).value()));
                LOGGER.debug("ModifyStateOutputFactory - builder getObjId = " + builder.getObjId());
                Object objtok = itr.next();
                while (!(objtok instanceof XmlElementStart)) {
                    objtok = itr.next();
                }
                while (objtok instanceof XmlElementStart) {
                    if (((XmlElementStart)objtok).name().equals("state")) {
                        String tmp = ((XmlElementStart)objtok).attributes().get(0).value();
                        builder.setStateType(StateType.valueOf((String)tmp));
                        LOGGER.debug("ModifyStateOutputFactory - builder getStateType = " + builder.getStateType());
                        String bufStr = MessageHelper.getCharVal(itr);
                        builder.setStateValue(StateVal.valueOf((String)bufStr));
                        LOGGER.debug("ModifyStateOutputFactory - builder getStateValue = " + builder.getStateValue());
                        while (!(objtok instanceof XmlElementEnd)) {
                            objtok = itr.next();
                        }
                        objtok = itr.next();
                        while (objtok instanceof XmlCharacters) {
                            objtok = itr.next();
                        }
                        LOGGER.debug("ModifyStateOutputFactory - found next: {}", objtok);
                    }
                    if (objtok instanceof XmlElementEnd) {
                        LOGGER.debug("ModifyStateOutputFactory - found XmlElementEnd: {}", objtok);
                        if (!((XmlElementEnd)objtok).name().equals("obj")) continue;
                        LOGGER.debug("ModifyStateOutputFactory - objtok20 = " + objtok);
                        continue;
                    }
                    while (!(objtok instanceof XmlElementStart)) {
                        LOGGER.debug("ModifyStateOutputFactory - objtok  xx = " + objtok);
                        objtok = itr.next();
                    }
                }
            }
            catch (Exception t) {
                LOGGER.error("Error " + tok + " " + t.toString());
            }
        }
        LOGGER.debug("ModifyStateOutputFactory - Builder: " + builder.build());
        return builder.build();
    }
}

