/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.ocpjava.protocol.impl.deserialization.factories.utils;

import java.util.Iterator;
import org.opendaylight.ocpjava.protocol.impl.core.XmlCharacters;
import org.opendaylight.ocpjava.protocol.impl.core.XmlElementStart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MessageHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(MessageHelper.class);

    public static String getMsgType(Iterator itr) {
        Object tok = itr.next();
        while (!(tok instanceof XmlElementStart)) {
            tok = itr.next();
        }
        String type = ((XmlElementStart)tok).name().toUpperCase();
        LOGGER.debug("MessageHelper - getMsgType = {}", (Object)type);
        return type;
    }

    public static String getMsgUID(Iterator itr) {
        Object tok = itr.next();
        String rel = "";
        while (tok instanceof XmlCharacters) {
            rel = rel.concat(((XmlCharacters)tok).data().toString().replace(" ", "").replace("\n", ""));
            tok = itr.next();
        }
        LOGGER.debug("MessageHelper - getMsgUID = {}", (Object)rel);
        return rel;
    }

    public static String getResult(Iterator itr) {
        Object tok = itr.next();
        String rel = "";
        while (tok instanceof XmlCharacters) {
            rel = rel.concat(((XmlCharacters)tok).data().toString().replace("_", "").replace(" ", "").replace("\n", ""));
            tok = itr.next();
        }
        LOGGER.debug("MessageHelper - getResult = {}", (Object)rel);
        return rel;
    }

    public static String getCharVal(Iterator itr) {
        Object tok = itr.next();
        String rel = "";
        while (tok instanceof XmlCharacters) {
            rel = rel.concat(((XmlCharacters)tok).data().toString().replace("_", "").replace(" ", "").replace("\n", ""));
            tok = itr.next();
        }
        LOGGER.debug("MessageHelper - getCharVal = {}", (Object)rel);
        return rel;
    }
}

