/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.ocpjava.protocol.impl.serialization;

import org.opendaylight.ocpjava.protocol.api.extensibility.OCPGeneralSerializer;
import org.opendaylight.ocpjava.protocol.api.extensibility.SerializerRegistry;
import org.opendaylight.ocpjava.protocol.impl.serialization.factories.CreateObjInputFactory;
import org.opendaylight.ocpjava.protocol.impl.serialization.factories.DeleteObjInputFactory;
import org.opendaylight.ocpjava.protocol.impl.serialization.factories.GetFaultInputFactory;
import org.opendaylight.ocpjava.protocol.impl.serialization.factories.GetParamInputFactory;
import org.opendaylight.ocpjava.protocol.impl.serialization.factories.GetStateInputFactory;
import org.opendaylight.ocpjava.protocol.impl.serialization.factories.HealthCheckInputFactory;
import org.opendaylight.ocpjava.protocol.impl.serialization.factories.HelloInputFactory;
import org.opendaylight.ocpjava.protocol.impl.serialization.factories.ModifyParamInputFactory;
import org.opendaylight.ocpjava.protocol.impl.serialization.factories.ModifyStateInputFactory;
import org.opendaylight.ocpjava.protocol.impl.serialization.factories.ReResetInputFactory;
import org.opendaylight.ocpjava.protocol.impl.serialization.factories.SetTimeInputFactory;
import org.opendaylight.ocpjava.protocol.impl.util.CommonMessageRegistryHelper;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.extension.rev150811.HelloInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.protocol.rev150811.CreateObjInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.protocol.rev150811.DeleteObjInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.protocol.rev150811.GetFaultInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.protocol.rev150811.GetParamInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.protocol.rev150811.GetStateInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.protocol.rev150811.HealthCheckInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.protocol.rev150811.ModifyParamInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.protocol.rev150811.ModifyStateInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.protocol.rev150811.ReResetInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.protocol.rev150811.SetTimeInput;

public final class MessageFactoryInitializer {
    private MessageFactoryInitializer() {
        throw new UnsupportedOperationException("Utility class shouldn't be instantiated");
    }

    public static void registerMessageSerializers(SerializerRegistry serializerRegistry) {
        short version = 1;
        CommonMessageRegistryHelper registryHelper = new CommonMessageRegistryHelper(version, serializerRegistry);
        registryHelper.registerSerializer(HealthCheckInput.class, (OCPGeneralSerializer)new HealthCheckInputFactory());
        registryHelper.registerSerializer(SetTimeInput.class, (OCPGeneralSerializer)new SetTimeInputFactory());
        registryHelper.registerSerializer(ReResetInput.class, (OCPGeneralSerializer)new ReResetInputFactory());
        registryHelper.registerSerializer(GetParamInput.class, (OCPGeneralSerializer)new GetParamInputFactory());
        registryHelper.registerSerializer(CreateObjInput.class, (OCPGeneralSerializer)new CreateObjInputFactory());
        registryHelper.registerSerializer(DeleteObjInput.class, (OCPGeneralSerializer)new DeleteObjInputFactory());
        registryHelper.registerSerializer(GetStateInput.class, (OCPGeneralSerializer)new GetStateInputFactory());
        registryHelper.registerSerializer(GetFaultInput.class, (OCPGeneralSerializer)new GetFaultInputFactory());
        registryHelper.registerSerializer(ModifyParamInput.class, (OCPGeneralSerializer)new ModifyParamInputFactory());
        registryHelper.registerSerializer(ModifyStateInput.class, (OCPGeneralSerializer)new ModifyStateInputFactory());
        registryHelper.registerSerializer(HelloInput.class, (OCPGeneralSerializer)new HelloInputFactory());
    }
}

