/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.ocpjava.protocol.impl.serialization;

import java.util.HashMap;
import java.util.Map;
import org.opendaylight.ocpjava.protocol.api.extensibility.OCPGeneralSerializer;
import org.opendaylight.ocpjava.protocol.api.extensibility.SerializerRegistry;
import org.opendaylight.ocpjava.protocol.api.extensibility.SerializerRegistryInjector;
import org.opendaylight.ocpjava.protocol.api.keys.MessageTypeKey;
import org.opendaylight.ocpjava.protocol.impl.serialization.MessageFactoryInitializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerializerRegistryImpl
implements SerializerRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(SerializerRegistryImpl.class);
    private Map<MessageTypeKey<?>, OCPGeneralSerializer> registry;

    public void init() {
        this.registry = new HashMap();
        MessageFactoryInitializer.registerMessageSerializers(this);
    }

    public <K, S extends OCPGeneralSerializer> S getSerializer(MessageTypeKey<K> msgTypeKey) {
        OCPGeneralSerializer serializer = this.registry.get(msgTypeKey);
        if (serializer == null) {
            throw new IllegalStateException("Serializer for key: " + msgTypeKey + " was not found - please verify that you are using correct message combination (e.g. OCP v4.1.1 message to OCP v4.1.1 device)");
        }
        return (S)serializer;
    }

    public <K> void registerSerializer(MessageTypeKey<K> msgTypeKey, OCPGeneralSerializer serializer) {
        if (msgTypeKey == null || serializer == null) {
            throw new IllegalArgumentException("MessageTypeKey or Serializer is null");
        }
        OCPGeneralSerializer serInRegistry = this.registry.put(msgTypeKey, serializer);
        if (serInRegistry != null) {
            LOGGER.debug("Serializer for key {} overwritten. Old serializer: {}, new serializer: {}", new Object[]{msgTypeKey, serInRegistry.getClass().getName(), serializer.getClass().getName()});
        }
        if (serializer instanceof SerializerRegistryInjector) {
            ((SerializerRegistryInjector)serializer).injectSerializerRegistry((SerializerRegistry)this);
        }
    }

    public <K> boolean unregisterSerializer(MessageTypeKey<K> msgTypeKey) {
        if (msgTypeKey == null) {
            throw new IllegalArgumentException("MessageTypeKey is null");
        }
        OCPGeneralSerializer serializer = this.registry.remove(msgTypeKey);
        return serializer != null;
    }
}

