/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.ocpjava.protocol.impl.serialization.factories;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import org.opendaylight.ocpjava.protocol.api.extensibility.OCPSerializer;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.protocol.rev150811.GetParamInput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetParamInputFactory
implements OCPSerializer<GetParamInput> {
    private static final String MESSAGE_TYPE = "getParamReq";
    private static final Logger LOGGER = LoggerFactory.getLogger(GetParamInputFactory.class);

    public void serialize(GetParamInput message, ByteBuf outBuffer) {
        LOGGER.debug("GetParamInputFactory - message = " + message.toString());
        StringBuilder seq = new StringBuilder("");
        seq.append("<msg xmlns=");
        seq.append("\"http://uri.etsi.org/ori/002-2/v4.1.1\">");
        seq.append("<header>");
        seq.append("<msgType>REQ</msgType>");
        seq.append("<msgUID>");
        seq.append(message.getXid().toString());
        seq.append("</msgUID>");
        seq.append("</header>");
        seq.append("<body>");
        seq.append("<");
        seq.append(MESSAGE_TYPE);
        seq.append(">");
        seq.append("<obj objID=\"");
        seq.append(message.getObjId().getValue().toString());
        seq.append("\">");
        seq.append("<param name=\"");
        seq.append(message.getParamName().toString());
        seq.append("\"/>");
        seq.append("</obj>");
        seq.append("</");
        seq.append(MESSAGE_TYPE);
        seq.append(">");
        seq.append("</body>");
        seq.append("</msg>");
        LOGGER.debug("GetParamInputFactory - composed xml-string = " + seq);
        ByteBufUtil.writeUtf8((ByteBuf)outBuffer, (CharSequence)seq);
    }
}

