/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.ocpjava.protocol.impl.serialization.factories;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import org.opendaylight.ocpjava.protocol.api.extensibility.OCPSerializer;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.extension.rev150811.HelloInput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HelloInputFactory
implements OCPSerializer<HelloInput> {
    private static final Logger LOGGER = LoggerFactory.getLogger(HelloInputFactory.class);

    public void serialize(HelloInput message, ByteBuf outBuffer) {
        LOGGER.debug("HelloInputFactory - message = " + message.toString());
        StringBuilder seq = new StringBuilder("");
        seq.append("<msg xmlns=");
        seq.append("\"http://uri.etsi.org/ori/002-2/v4.1.1\">");
        seq.append("<header>");
        seq.append("<msgType>ACK</msgType>");
        seq.append("<msgUID>");
        seq.append(message.getXid());
        seq.append("</msgUID>");
        seq.append("</header>");
        seq.append("<body>");
        seq.append("<helloAck>");
        seq.append("<result>");
        seq.append(message.getResult().toString());
        seq.append("</result>");
        seq.append("</helloAck>");
        seq.append("</body>");
        seq.append("</msg>");
        LOGGER.debug("HelloInputFactory - composed xml-string = " + seq);
        ByteBufUtil.writeUtf8((ByteBuf)outBuffer, (CharSequence)seq);
    }
}

