/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ocp.radiohead.connection.provider.impl.rev150811;

import org.opendaylight.controller.config.api.DependencyResolver;
import org.opendaylight.controller.config.api.ModuleIdentifier;
import org.opendaylight.ocpjava.protocol.api.connection.OcpStatisticsConfiguration;
import org.opendaylight.ocpjava.protocol.spi.statistics.OcpStatisticsHandler;
import org.opendaylight.ocpjava.statistics.OcpStatisticsCounters;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ocp.radiohead.connection.provider.impl.rev150811.AbstractOcpStatisticsCollectionModule;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ocp.radiohead.connection.provider.impl.rev150811.OcpStatistics;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ocp.radiohead.connection.provider.impl.rev150811.OcpStatisticsCollectionRuntimeMXBean;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ocp.radiohead.connection.provider.impl.rev150811.OcpStatisticsCollectionRuntimeRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OcpStatisticsCollectionModule
extends AbstractOcpStatisticsCollectionModule {
    private static final Logger LOGGER = LoggerFactory.getLogger(OcpStatisticsCollectionModule.class);

    public OcpStatisticsCollectionModule(ModuleIdentifier identifier, DependencyResolver dependencyResolver) {
        super(identifier, dependencyResolver);
    }

    public OcpStatisticsCollectionModule(ModuleIdentifier identifier, DependencyResolver dependencyResolver, OcpStatisticsCollectionModule oldModule, AutoCloseable oldInstance) {
        super(identifier, dependencyResolver, oldModule, oldInstance);
    }

    @Override
    public void customValidation() {
    }

    public AutoCloseable createInstance() {
        final OcpStatistics statistics = this.getOcpStatistics();
        final OcpStatisticsCounters statsCounter = OcpStatisticsCounters.getInstance();
        OcpStatisticsConfiguration statsConfig = null;
        if (statistics != null) {
            statsConfig = new OcpStatisticsConfiguration(){

                public boolean getOcpStatisticsCollect() {
                    if (statistics.getOcpStatisticsCollect() != null) {
                        return statistics.getOcpStatisticsCollect();
                    }
                    return false;
                }

                public int getLogReportDelay() {
                    if (statistics.getLogReportDelay() != null) {
                        return statistics.getLogReportDelay();
                    }
                    return 0;
                }
            };
        }
        if (statsConfig != null) {
            statsCounter.startCounting(statsConfig.getOcpStatisticsCollect(), statsConfig.getLogReportDelay());
        } else {
            LOGGER.debug("Unable to start OcpStatisticCounter - wrong configuration");
        }
        OcpStatisticsCollectionRuntimeMXBean collectionBean = new OcpStatisticsCollectionRuntimeMXBean(){

            @Override
            public String printOcpjavaOcpStatistics() {
                if (statsCounter != null) {
                    return statsCounter.printOcpStatistics();
                }
                return "OcpStatistics collection is not avaliable.";
            }

            @Override
            public String getMsgOcpStatistics() {
                return this.printOcpjavaOcpStatistics();
            }

            @Override
            public String resetOcpjavaOcpStatistics() {
                statsCounter.resetCounters();
                return "OcpStatistics have been reset";
            }
        };
        final OcpStatisticsCollectionRuntimeRegistration runtimeReg = this.getRootRuntimeBeanRegistratorWrapper().register(collectionBean);
        final class AutoClosableOcpStatisticsCollection
        implements OcpStatisticsHandler,
        AutoCloseable {
            AutoClosableOcpStatisticsCollection() {
            }

            @Override
            public void close() {
                if (runtimeReg != null) {
                    try {
                        runtimeReg.close();
                    }
                    catch (Exception e) {
                        String errMsg = "Error by stoping OcpStatisticsCollectionService.";
                        LOGGER.error(errMsg, (Throwable)e);
                        throw new IllegalStateException(errMsg, e);
                    }
                }
                LOGGER.info("OcpStatisticsCollection Service consumer (instance {} turn down.)", (Object)this);
            }

            public void resetCounters() {
                statsCounter.resetCounters();
            }

            public String printOcpStatistics() {
                return statsCounter.printOcpStatistics();
            }
        }
        AutoClosableOcpStatisticsCollection ret = new AutoClosableOcpStatisticsCollection();
        LOGGER.info("OcpStatisticsCollection service (instance {}) initialized.", (Object)ret);
        return ret;
    }
}

