/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ocp.radiohead.connection.provider.impl.rev150811;

import com.google.common.base.MoreObjects;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.opendaylight.controller.config.api.DependencyResolver;
import org.opendaylight.controller.config.api.ModuleIdentifier;
import org.opendaylight.ocpjava.protocol.api.connection.ConnectionConfiguration;
import org.opendaylight.ocpjava.protocol.api.connection.ThreadConfiguration;
import org.opendaylight.ocpjava.protocol.api.connection.TlsConfiguration;
import org.opendaylight.ocpjava.protocol.impl.core.RadioHeadConnectionProviderImpl;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpAddress;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.config.rev150811.KeystoreType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.config.rev150811.PathType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.config.rev150811.TransportProtocol;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ocp.radiohead.connection.provider.impl.rev150811.AbstractRadioHeadConnectionProviderModule;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ocp.radiohead.connection.provider.impl.rev150811.Threads;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ocp.radiohead.connection.provider.impl.rev150811.Tls;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RadioHeadConnectionProviderModule
extends AbstractRadioHeadConnectionProviderModule {
    private static Logger LOG = LoggerFactory.getLogger(RadioHeadConnectionProviderModule.class);

    public RadioHeadConnectionProviderModule(ModuleIdentifier identifier, DependencyResolver dependencyResolver) {
        super(identifier, dependencyResolver);
    }

    public RadioHeadConnectionProviderModule(ModuleIdentifier identifier, DependencyResolver dependencyResolver, RadioHeadConnectionProviderModule oldModule, AutoCloseable oldInstance) {
        super(identifier, dependencyResolver, oldModule, oldInstance);
    }

    @Override
    protected void customValidation() {
    }

    public AutoCloseable createInstance() {
        LOG.info("RadioHeadConnectionProvider started.");
        RadioHeadConnectionProviderImpl radioHeadConnectionProviderImpl = new RadioHeadConnectionProviderImpl();
        try {
            ConnectionConfiguration connConfiguration = this.createConnectionConfiguration();
            radioHeadConnectionProviderImpl.setConfiguration(connConfiguration);
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        return radioHeadConnectionProviderImpl;
    }

    private ConnectionConfiguration createConnectionConfiguration() throws UnknownHostException {
        final InetAddress address = RadioHeadConnectionProviderModule.extractIpAddressBin(this.getAddress());
        final Integer port = this.getPort();
        final long radioHeadIdleTimeout = this.getRadioHeadIdleTimeout();
        final Tls tlsConfig = this.getTls();
        final Threads threads = this.getThreads();
        final TransportProtocol transportProtocol = this.getTransportProtocol();
        return new ConnectionConfiguration(){

            public InetAddress getAddress() {
                return address;
            }

            public int getPort() {
                return port;
            }

            public Object getTransferProtocol() {
                return transportProtocol;
            }

            public TlsConfiguration getTlsConfiguration() {
                if (tlsConfig == null || !TransportProtocol.TLS.equals((Object)transportProtocol)) {
                    return null;
                }
                return new TlsConfiguration(){

                    public KeystoreType getTlsTruststoreType() {
                        return (KeystoreType)MoreObjects.firstNonNull((Object)tlsConfig.getTruststoreType(), null);
                    }

                    public String getTlsTruststore() {
                        return (String)MoreObjects.firstNonNull((Object)tlsConfig.getTruststore(), null);
                    }

                    public KeystoreType getTlsKeystoreType() {
                        return (KeystoreType)MoreObjects.firstNonNull((Object)tlsConfig.getKeystoreType(), null);
                    }

                    public String getTlsKeystore() {
                        return (String)MoreObjects.firstNonNull((Object)tlsConfig.getKeystore(), null);
                    }

                    public PathType getTlsKeystorePathType() {
                        return (PathType)MoreObjects.firstNonNull((Object)tlsConfig.getKeystorePathType(), null);
                    }

                    public PathType getTlsTruststorePathType() {
                        return (PathType)MoreObjects.firstNonNull((Object)tlsConfig.getTruststorePathType(), null);
                    }

                    public String getKeystorePassword() {
                        return (String)MoreObjects.firstNonNull((Object)tlsConfig.getKeystorePassword(), null);
                    }

                    public String getCertificatePassword() {
                        return (String)MoreObjects.firstNonNull((Object)tlsConfig.getCertificatePassword(), null);
                    }

                    public String getTruststorePassword() {
                        return (String)MoreObjects.firstNonNull((Object)tlsConfig.getTruststorePassword(), null);
                    }
                };
            }

            public long getRadioHeadIdleTimeout() {
                return radioHeadIdleTimeout;
            }

            public Object getSslContext() {
                return null;
            }

            public ThreadConfiguration getThreadConfiguration() {
                if (threads == null) {
                    return null;
                }
                return new ThreadConfiguration(){

                    public int getWorkerThreadCount() {
                        return threads.getWorkerThreads();
                    }

                    public int getBossThreadCount() {
                        return threads.getBossThreads();
                    }
                };
            }
        };
    }

    private static InetAddress extractIpAddressBin(IpAddress address) throws UnknownHostException {
        byte[] addressBin = null;
        if (address != null) {
            if (address.getIpv4Address() != null) {
                addressBin = RadioHeadConnectionProviderModule.address2bin(address.getIpv4Address().getValue());
            } else if (address.getIpv6Address() != null) {
                addressBin = RadioHeadConnectionProviderModule.address2bin(address.getIpv6Address().getValue());
            }
        }
        if (addressBin == null) {
            return null;
        }
        return InetAddress.getByAddress(addressBin);
    }

    private static byte[] address2bin(String value) {
        return null;
    }
}

