/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ocp.radiohead.connection.provider.impl.rev150811.modules.module.configuration.ocp.radiohead.connection.provider.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.config.rev150811.KeystoreType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.config.rev150811.PathType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ocp.radiohead.connection.provider.impl.rev150811.modules.module.configuration.ocp.radiohead.connection.provider.impl.Tls;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class TlsBuilder
implements Builder<Tls> {
    private String _certificatePassword;
    private String _keystore;
    private String _keystorePassword;
    private PathType _keystorePathType;
    private KeystoreType _keystoreType;
    private String _truststore;
    private String _truststorePassword;
    private PathType _truststorePathType;
    private KeystoreType _truststoreType;
    Map<Class<? extends Augmentation<Tls>>, Augmentation<Tls>> augmentation = Collections.emptyMap();

    public TlsBuilder() {
    }

    public TlsBuilder(Tls base) {
        AugmentationHolder casted;
        this._certificatePassword = base.getCertificatePassword();
        this._keystore = base.getKeystore();
        this._keystorePassword = base.getKeystorePassword();
        this._keystorePathType = base.getKeystorePathType();
        this._keystoreType = base.getKeystoreType();
        this._truststore = base.getTruststore();
        this._truststorePassword = base.getTruststorePassword();
        this._truststorePathType = base.getTruststorePathType();
        this._truststoreType = base.getTruststoreType();
        if (base instanceof TlsImpl) {
            TlsImpl impl = (TlsImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<Tls>>, Augmentation<Tls>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Tls>>, Augmentation<Tls>>(casted.augmentations());
        }
    }

    public String getCertificatePassword() {
        return this._certificatePassword;
    }

    public String getKeystore() {
        return this._keystore;
    }

    public String getKeystorePassword() {
        return this._keystorePassword;
    }

    public PathType getKeystorePathType() {
        return this._keystorePathType;
    }

    public KeystoreType getKeystoreType() {
        return this._keystoreType;
    }

    public String getTruststore() {
        return this._truststore;
    }

    public String getTruststorePassword() {
        return this._truststorePassword;
    }

    public PathType getTruststorePathType() {
        return this._truststorePathType;
    }

    public KeystoreType getTruststoreType() {
        return this._truststoreType;
    }

    public <E extends Augmentation<Tls>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public TlsBuilder setCertificatePassword(String value) {
        this._certificatePassword = value;
        return this;
    }

    public TlsBuilder setKeystore(String value) {
        this._keystore = value;
        return this;
    }

    public TlsBuilder setKeystorePassword(String value) {
        this._keystorePassword = value;
        return this;
    }

    public TlsBuilder setKeystorePathType(PathType value) {
        this._keystorePathType = value;
        return this;
    }

    public TlsBuilder setKeystoreType(KeystoreType value) {
        this._keystoreType = value;
        return this;
    }

    public TlsBuilder setTruststore(String value) {
        this._truststore = value;
        return this;
    }

    public TlsBuilder setTruststorePassword(String value) {
        this._truststorePassword = value;
        return this;
    }

    public TlsBuilder setTruststorePathType(PathType value) {
        this._truststorePathType = value;
        return this;
    }

    public TlsBuilder setTruststoreType(KeystoreType value) {
        this._truststoreType = value;
        return this;
    }

    public TlsBuilder addAugmentation(Class<? extends Augmentation<Tls>> augmentationType, Augmentation<Tls> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Tls>>, Augmentation<Tls>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public TlsBuilder removeAugmentation(Class<? extends Augmentation<Tls>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Tls build() {
        return new TlsImpl(this);
    }

    private static final class TlsImpl
    implements Tls {
        private final String _certificatePassword;
        private final String _keystore;
        private final String _keystorePassword;
        private final PathType _keystorePathType;
        private final KeystoreType _keystoreType;
        private final String _truststore;
        private final String _truststorePassword;
        private final PathType _truststorePathType;
        private final KeystoreType _truststoreType;
        private Map<Class<? extends Augmentation<Tls>>, Augmentation<Tls>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<Tls> getImplementedInterface() {
            return Tls.class;
        }

        private TlsImpl(TlsBuilder base) {
            this._certificatePassword = base.getCertificatePassword();
            this._keystore = base.getKeystore();
            this._keystorePassword = base.getKeystorePassword();
            this._keystorePathType = base.getKeystorePathType();
            this._keystoreType = base.getKeystoreType();
            this._truststore = base.getTruststore();
            this._truststorePassword = base.getTruststorePassword();
            this._truststorePathType = base.getTruststorePathType();
            this._truststoreType = base.getTruststoreType();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<Tls>>, Augmentation<Tls>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<Tls>>, Augmentation<Tls>>(base.augmentation);
                }
            }
        }

        @Override
        public String getCertificatePassword() {
            return this._certificatePassword;
        }

        @Override
        public String getKeystore() {
            return this._keystore;
        }

        @Override
        public String getKeystorePassword() {
            return this._keystorePassword;
        }

        @Override
        public PathType getKeystorePathType() {
            return this._keystorePathType;
        }

        @Override
        public KeystoreType getKeystoreType() {
            return this._keystoreType;
        }

        @Override
        public String getTruststore() {
            return this._truststore;
        }

        @Override
        public String getTruststorePassword() {
            return this._truststorePassword;
        }

        @Override
        public PathType getTruststorePathType() {
            return this._truststorePathType;
        }

        @Override
        public KeystoreType getTruststoreType() {
            return this._truststoreType;
        }

        public <E extends Augmentation<Tls>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._certificatePassword);
            result = 31 * result + Objects.hashCode(this._keystore);
            result = 31 * result + Objects.hashCode(this._keystorePassword);
            result = 31 * result + Objects.hashCode(this._keystorePathType);
            result = 31 * result + Objects.hashCode(this._keystoreType);
            result = 31 * result + Objects.hashCode(this._truststore);
            result = 31 * result + Objects.hashCode(this._truststorePassword);
            result = 31 * result + Objects.hashCode(this._truststorePathType);
            result = 31 * result + Objects.hashCode(this._truststoreType);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Tls.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Tls other = (Tls)obj;
            if (!Objects.equals(this._certificatePassword, other.getCertificatePassword())) {
                return false;
            }
            if (!Objects.equals(this._keystore, other.getKeystore())) {
                return false;
            }
            if (!Objects.equals(this._keystorePassword, other.getKeystorePassword())) {
                return false;
            }
            if (!Objects.equals(this._keystorePathType, other.getKeystorePathType())) {
                return false;
            }
            if (!Objects.equals(this._keystoreType, other.getKeystoreType())) {
                return false;
            }
            if (!Objects.equals(this._truststore, other.getTruststore())) {
                return false;
            }
            if (!Objects.equals(this._truststorePassword, other.getTruststorePassword())) {
                return false;
            }
            if (!Objects.equals(this._truststorePathType, other.getTruststorePathType())) {
                return false;
            }
            if (!Objects.equals(this._truststoreType, other.getTruststoreType())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                TlsImpl otherImpl = (TlsImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Tls>>, Augmentation<Tls>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "Tls [";
            StringBuilder builder = new StringBuilder(name);
            if (this._certificatePassword != null) {
                builder.append("_certificatePassword=");
                builder.append(this._certificatePassword);
                builder.append(", ");
            }
            if (this._keystore != null) {
                builder.append("_keystore=");
                builder.append(this._keystore);
                builder.append(", ");
            }
            if (this._keystorePassword != null) {
                builder.append("_keystorePassword=");
                builder.append(this._keystorePassword);
                builder.append(", ");
            }
            if (this._keystorePathType != null) {
                builder.append("_keystorePathType=");
                builder.append(this._keystorePathType);
                builder.append(", ");
            }
            if (this._keystoreType != null) {
                builder.append("_keystoreType=");
                builder.append(this._keystoreType);
                builder.append(", ");
            }
            if (this._truststore != null) {
                builder.append("_truststore=");
                builder.append(this._truststore);
                builder.append(", ");
            }
            if (this._truststorePassword != null) {
                builder.append("_truststorePassword=");
                builder.append(this._truststorePassword);
                builder.append(", ");
            }
            if (this._truststorePathType != null) {
                builder.append("_truststorePathType=");
                builder.append(this._truststorePathType);
                builder.append(", ");
            }
            if (this._truststoreType != null) {
                builder.append("_truststoreType=");
                builder.append(this._truststoreType);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

