package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ocp.radiohead.connection.provider.impl.rev150811;
import org.opendaylight.yangtools.yang.binding.RpcService;
import org.opendaylight.yangtools.yang.common.RpcResult;
import java.util.concurrent.Future;

/**
 * Interface for implementing the following YANG RPCs defined in module <b>ocp-radiohead-connection-provider-impl</b>
 * <pre>
 * rpc print-ocpjava-ocp-statistics {
 *     "Shortcut JMX call to printOcpjavaStatistics.";
 *     input {
 *         leaf context-instance {
 *             type instance-identifier;
 *         }
 *     }
 *     
 *     output {
 *         leaf result {
 *             type string;
 *         }
 *     }
 * }
 * rpc reset-ocpjava-ocp-statistics {
 *     "Shortcut JMX call to resetOcpjavaStatistics.";
 *     input {
 *         leaf context-instance {
 *             type instance-identifier;
 *         }
 *     }
 *     
 *     output {
 *         leaf result {
 *             type string;
 *         }
 *     }
 * }
 * </pre>
 *
 */
public interface OcpRadioheadConnectionProviderImplService
    extends
    RpcService
{




    /**
     * Shortcut JMX call to printOcpjavaStatistics.
     *
     */
    Future<RpcResult<PrintOcpjavaOcpStatisticsOutput>> printOcpjavaOcpStatistics(PrintOcpjavaOcpStatisticsInput input);
    
    /**
     * Shortcut JMX call to resetOcpjavaStatistics.
     *
     */
    Future<RpcResult<ResetOcpjavaOcpStatisticsOutput>> resetOcpjavaOcpStatistics(ResetOcpjavaOcpStatisticsInput input);

}

