package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ocp.radiohead.connection.provider.impl.rev150811.modules.module.configuration;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ocp.radiohead.connection.provider.impl.rev150811.modules.module.configuration.ocp.radiohead.connection.provider.impl.Threads;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.rev130405.modules.module.Configuration;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpAddress;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ocp.radiohead.connection.provider.impl.rev150811.modules.module.configuration.ocp.radiohead.connection.provider.impl.Tls;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.config.rev150811.TransportProtocol;
import org.opendaylight.yangtools.yang.binding.Augmentable;

/**
 * <p>This class represents the following YANG schema fragment defined in module <b>ocp-radiohead-connection-provider-impl</b>
 * <pre>
 * case ocp-radiohead-connection-provider-impl {
 *     leaf port {
 *         type uint16;
 *     }
 *     leaf address {
 *         type ip-address;
 *     }
 *     leaf transport-protocol {
 *         type transport-protocol;
 *     }
 *     leaf radioHead-idle-timeout {
 *         type uint32;
 *     }
 *     container tls {
 *         leaf keystore {
 *             type string;
 *         }
 *         leaf keystore-type {
 *             type keystore-type;
 *         }
 *         leaf keystore-path-type {
 *             type path-type;
 *         }
 *         leaf keystore-password {
 *             type string;
 *         }
 *         leaf certificate-password {
 *             type string;
 *         }
 *         leaf truststore {
 *             type string;
 *         }
 *         leaf truststore-type {
 *             type keystore-type;
 *         }
 *         leaf truststore-path-type {
 *             type path-type;
 *         }
 *         leaf truststore-password {
 *             type string;
 *         }
 *     }
 *     container threads {
 *         leaf boss-threads {
 *             type uint16;
 *         }
 *         leaf worker-threads {
 *             type uint16;
 *         }
 *     }
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>ocp-radiohead-connection-provider-impl/modules/module/configuration/(urn:opendaylight:params:xml:ns:yang:ocp:radiohead:connection:provider:impl?revision=2015-08-11)ocp-radiohead-connection-provider-impl</i>
 *
 */
public interface OcpRadioheadConnectionProviderImpl
    extends
    DataObject,
    Augmentable<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ocp.radiohead.connection.provider.impl.rev150811.modules.module.configuration.OcpRadioheadConnectionProviderImpl>,
    Configuration
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:params:xml:ns:yang:ocp:radiohead:connection:provider:impl",
        "2015-08-11", "ocp-radiohead-connection-provider-impl").intern();

    /**
     * local listening port
     *
     *
     *
     * @return <code>java.lang.Integer</code> <code>port</code>, or <code>null</code> if not present
     */
    java.lang.Integer getPort();
    
    /**
     * address of local listening interface
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpAddress</code> <code>address</code>, or <code>null</code> if not present
     */
    IpAddress getAddress();
    
    /**
     * Transport protocol used for communication.
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.config.rev150811.TransportProtocol</code> <code>transportProtocol</code>, or <code>null</code> if not present
     */
    TransportProtocol getTransportProtocol();
    
    /**
     * idle timeout in [ms]
     *
     *
     *
     * @return <code>java.lang.Long</code> <code>radioHeadIdleTimeout</code>, or <code>null</code> if not present
     */
    java.lang.Long getRadioHeadIdleTimeout();
    
    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ocp.radiohead.connection.provider.impl.rev150811.modules.module.configuration.ocp.radiohead.connection.provider.impl.Tls</code> <code>tls</code>, or <code>null</code> if not present
     */
    Tls getTls();
    
    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ocp.radiohead.connection.provider.impl.rev150811.modules.module.configuration.ocp.radiohead.connection.provider.impl.Threads</code> <code>threads</code>, or <code>null</code> if not present
     */
    Threads getThreads();

}

