package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ocp.radiohead.connection.provider.impl.rev150811.modules.module.configuration;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ocp.radiohead.connection.provider.impl.rev150811.modules.module.configuration.ocp.radiohead.connection.provider.impl.Threads;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;
import java.util.HashMap;
import org.opendaylight.yangtools.concepts.Builder;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpAddress;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ocp.radiohead.connection.provider.impl.rev150811.modules.module.configuration.ocp.radiohead.connection.provider.impl.Tls;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.config.rev150811.TransportProtocol;
import java.util.Collections;
import java.util.Map;

/**
 * Class that builds {@link org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ocp.radiohead.connection.provider.impl.rev150811.modules.module.configuration.OcpRadioheadConnectionProviderImpl} instances.
 *
 * @see org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ocp.radiohead.connection.provider.impl.rev150811.modules.module.configuration.OcpRadioheadConnectionProviderImpl
 *
 */
public class OcpRadioheadConnectionProviderImplBuilder implements Builder<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ocp.radiohead.connection.provider.impl.rev150811.modules.module.configuration.OcpRadioheadConnectionProviderImpl> {

    private IpAddress _address;
    private java.lang.Integer _port;
    private java.lang.Long _radioHeadIdleTimeout;
    private Threads _threads;
    private Tls _tls;
    private TransportProtocol _transportProtocol;

    Map<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ocp.radiohead.connection.provider.impl.rev150811.modules.module.configuration.OcpRadioheadConnectionProviderImpl>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ocp.radiohead.connection.provider.impl.rev150811.modules.module.configuration.OcpRadioheadConnectionProviderImpl>> augmentation = Collections.emptyMap();

    public OcpRadioheadConnectionProviderImplBuilder() {
    }

    public OcpRadioheadConnectionProviderImplBuilder(OcpRadioheadConnectionProviderImpl base) {
        this._address = base.getAddress();
        this._port = base.getPort();
        this._radioHeadIdleTimeout = base.getRadioHeadIdleTimeout();
        this._threads = base.getThreads();
        this._tls = base.getTls();
        this._transportProtocol = base.getTransportProtocol();
        if (base instanceof OcpRadioheadConnectionProviderImplImpl) {
            OcpRadioheadConnectionProviderImplImpl impl = (OcpRadioheadConnectionProviderImplImpl) base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            AugmentationHolder<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ocp.radiohead.connection.provider.impl.rev150811.modules.module.configuration.OcpRadioheadConnectionProviderImpl> casted =(AugmentationHolder<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ocp.radiohead.connection.provider.impl.rev150811.modules.module.configuration.OcpRadioheadConnectionProviderImpl>) base;
            if (!casted.augmentations().isEmpty()) {
                this.augmentation = new HashMap<>(casted.augmentations());
            }
        }
    }


    public IpAddress getAddress() {
        return _address;
    }
    
    public java.lang.Integer getPort() {
        return _port;
    }
    
    public java.lang.Long getRadioHeadIdleTimeout() {
        return _radioHeadIdleTimeout;
    }
    
    public Threads getThreads() {
        return _threads;
    }
    
    public Tls getTls() {
        return _tls;
    }
    
    public TransportProtocol getTransportProtocol() {
        return _transportProtocol;
    }
    
    @SuppressWarnings("unchecked")
    public <E extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ocp.radiohead.connection.provider.impl.rev150811.modules.module.configuration.OcpRadioheadConnectionProviderImpl>> E getAugmentation(java.lang.Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E) augmentation.get(augmentationType);
    }

     
    public OcpRadioheadConnectionProviderImplBuilder setAddress(final IpAddress value) {
        this._address = value;
        return this;
    }
    
     
     private static void checkPortRange(final int value) {
         if (value >= 0 && value <= 65535) {
             return;
         }
         throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0‥65535]].", value));
     }
    
    public OcpRadioheadConnectionProviderImplBuilder setPort(final java.lang.Integer value) {
    if (value != null) {
        checkPortRange(value);
    }
        this._port = value;
        return this;
    }
    
     
     private static void checkRadioHeadIdleTimeoutRange(final long value) {
         if (value >= 0L && value <= 4294967295L) {
             return;
         }
         throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0‥4294967295]].", value));
     }
    
    public OcpRadioheadConnectionProviderImplBuilder setRadioHeadIdleTimeout(final java.lang.Long value) {
    if (value != null) {
        checkRadioHeadIdleTimeoutRange(value);
    }
        this._radioHeadIdleTimeout = value;
        return this;
    }
    
     
    public OcpRadioheadConnectionProviderImplBuilder setThreads(final Threads value) {
        this._threads = value;
        return this;
    }
    
     
    public OcpRadioheadConnectionProviderImplBuilder setTls(final Tls value) {
        this._tls = value;
        return this;
    }
    
     
    public OcpRadioheadConnectionProviderImplBuilder setTransportProtocol(final TransportProtocol value) {
        this._transportProtocol = value;
        return this;
    }
    
    public OcpRadioheadConnectionProviderImplBuilder addAugmentation(java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ocp.radiohead.connection.provider.impl.rev150811.modules.module.configuration.OcpRadioheadConnectionProviderImpl>> augmentationType, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ocp.radiohead.connection.provider.impl.rev150811.modules.module.configuration.OcpRadioheadConnectionProviderImpl> augmentation) {
        if (augmentation == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    public OcpRadioheadConnectionProviderImplBuilder removeAugmentation(java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ocp.radiohead.connection.provider.impl.rev150811.modules.module.configuration.OcpRadioheadConnectionProviderImpl>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public OcpRadioheadConnectionProviderImpl build() {
        return new OcpRadioheadConnectionProviderImplImpl(this);
    }

    private static final class OcpRadioheadConnectionProviderImplImpl implements OcpRadioheadConnectionProviderImpl {

        @Override
        public java.lang.Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ocp.radiohead.connection.provider.impl.rev150811.modules.module.configuration.OcpRadioheadConnectionProviderImpl> getImplementedInterface() {
            return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ocp.radiohead.connection.provider.impl.rev150811.modules.module.configuration.OcpRadioheadConnectionProviderImpl.class;
        }

        private final IpAddress _address;
        private final java.lang.Integer _port;
        private final java.lang.Long _radioHeadIdleTimeout;
        private final Threads _threads;
        private final Tls _tls;
        private final TransportProtocol _transportProtocol;

        private Map<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ocp.radiohead.connection.provider.impl.rev150811.modules.module.configuration.OcpRadioheadConnectionProviderImpl>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ocp.radiohead.connection.provider.impl.rev150811.modules.module.configuration.OcpRadioheadConnectionProviderImpl>> augmentation = Collections.emptyMap();

        private OcpRadioheadConnectionProviderImplImpl(OcpRadioheadConnectionProviderImplBuilder base) {
            this._address = base.getAddress();
            this._port = base.getPort();
            this._radioHeadIdleTimeout = base.getRadioHeadIdleTimeout();
            this._threads = base.getThreads();
            this._tls = base.getTls();
            this._transportProtocol = base.getTransportProtocol();
            switch (base.augmentation.size()) {
            case 0:
                this.augmentation = Collections.emptyMap();
                break;
            case 1:
                final Map.Entry<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ocp.radiohead.connection.provider.impl.rev150811.modules.module.configuration.OcpRadioheadConnectionProviderImpl>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ocp.radiohead.connection.provider.impl.rev150811.modules.module.configuration.OcpRadioheadConnectionProviderImpl>> e = base.augmentation.entrySet().iterator().next();
                this.augmentation = Collections.<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ocp.radiohead.connection.provider.impl.rev150811.modules.module.configuration.OcpRadioheadConnectionProviderImpl>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ocp.radiohead.connection.provider.impl.rev150811.modules.module.configuration.OcpRadioheadConnectionProviderImpl>>singletonMap(e.getKey(), e.getValue());
                break;
            default :
                this.augmentation = new HashMap<>(base.augmentation);
            }
        }

        @Override
        public IpAddress getAddress() {
            return _address;
        }
        
        @Override
        public java.lang.Integer getPort() {
            return _port;
        }
        
        @Override
        public java.lang.Long getRadioHeadIdleTimeout() {
            return _radioHeadIdleTimeout;
        }
        
        @Override
        public Threads getThreads() {
            return _threads;
        }
        
        @Override
        public Tls getTls() {
            return _tls;
        }
        
        @Override
        public TransportProtocol getTransportProtocol() {
            return _transportProtocol;
        }
        
        @SuppressWarnings("unchecked")
        @Override
        public <E extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ocp.radiohead.connection.provider.impl.rev150811.modules.module.configuration.OcpRadioheadConnectionProviderImpl>> E getAugmentation(java.lang.Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E) augmentation.get(augmentationType);
        }

        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_address);
            result = prime * result + Objects.hashCode(_port);
            result = prime * result + Objects.hashCode(_radioHeadIdleTimeout);
            result = prime * result + Objects.hashCode(_threads);
            result = prime * result + Objects.hashCode(_tls);
            result = prime * result + Objects.hashCode(_transportProtocol);
            result = prime * result + Objects.hashCode(augmentation);
        
            hash = result;
            hashValid = true;
            return result;
        }

        @Override
        public boolean equals(java.lang.Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ocp.radiohead.connection.provider.impl.rev150811.modules.module.configuration.OcpRadioheadConnectionProviderImpl.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ocp.radiohead.connection.provider.impl.rev150811.modules.module.configuration.OcpRadioheadConnectionProviderImpl other = (org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ocp.radiohead.connection.provider.impl.rev150811.modules.module.configuration.OcpRadioheadConnectionProviderImpl)obj;
            if (!Objects.equals(_address, other.getAddress())) {
                return false;
            }
            if (!Objects.equals(_port, other.getPort())) {
                return false;
            }
            if (!Objects.equals(_radioHeadIdleTimeout, other.getRadioHeadIdleTimeout())) {
                return false;
            }
            if (!Objects.equals(_threads, other.getThreads())) {
                return false;
            }
            if (!Objects.equals(_tls, other.getTls())) {
                return false;
            }
            if (!Objects.equals(_transportProtocol, other.getTransportProtocol())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                OcpRadioheadConnectionProviderImplImpl otherImpl = (OcpRadioheadConnectionProviderImplImpl) obj;
                if (!Objects.equals(augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ocp.radiohead.connection.provider.impl.rev150811.modules.module.configuration.OcpRadioheadConnectionProviderImpl>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ocp.radiohead.connection.provider.impl.rev150811.modules.module.configuration.OcpRadioheadConnectionProviderImpl>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.getAugmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        @Override
        public java.lang.String toString() {
            java.lang.String name = "OcpRadioheadConnectionProviderImpl [";
            java.lang.StringBuilder builder = new java.lang.StringBuilder (name);
            if (_address != null) {
                builder.append("_address=");
                builder.append(_address);
                builder.append(", ");
            }
            if (_port != null) {
                builder.append("_port=");
                builder.append(_port);
                builder.append(", ");
            }
            if (_radioHeadIdleTimeout != null) {
                builder.append("_radioHeadIdleTimeout=");
                builder.append(_radioHeadIdleTimeout);
                builder.append(", ");
            }
            if (_threads != null) {
                builder.append("_threads=");
                builder.append(_threads);
                builder.append(", ");
            }
            if (_tls != null) {
                builder.append("_tls=");
                builder.append(_tls);
                builder.append(", ");
            }
            if (_transportProtocol != null) {
                builder.append("_transportProtocol=");
                builder.append(_transportProtocol);
            }
            final int builderLength = builder.length();
            final int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(augmentation.values());
            return builder.append(']').toString();
        }
    }

}
