package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ocp.radiohead.connection.provider.impl.rev150811.modules.module.configuration.ocp.radiohead.connection.provider.impl;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.rev130405.modules.Module;
import org.opendaylight.yangtools.yang.binding.Augmentable;

/**
 * <p>This class represents the following YANG schema fragment defined in module <b>ocp-radiohead-connection-provider-impl</b>
 * <pre>
 * container threads {
 *     leaf boss-threads {
 *         type uint16;
 *     }
 *     leaf worker-threads {
 *         type uint16;
 *     }
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>ocp-radiohead-connection-provider-impl/modules/module/configuration/(urn:opendaylight:params:xml:ns:yang:ocp:radiohead:connection:provider:impl?revision=2015-08-11)ocp-radiohead-connection-provider-impl/threads</i>
 *
 * <p>To create instances of this class use {@link org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ocp.radiohead.connection.provider.impl.rev150811.modules.module.configuration.ocp.radiohead.connection.provider.impl.ThreadsBuilder}.
 * @see org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ocp.radiohead.connection.provider.impl.rev150811.modules.module.configuration.ocp.radiohead.connection.provider.impl.ThreadsBuilder
 *
 */
public interface Threads
    extends
    ChildOf<Module>,
    Augmentable<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ocp.radiohead.connection.provider.impl.rev150811.modules.module.configuration.ocp.radiohead.connection.provider.impl.Threads>
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:params:xml:ns:yang:ocp:radiohead:connection:provider:impl",
        "2015-08-11", "threads").intern();

    /**
     * @return <code>java.lang.Integer</code> <code>bossThreads</code>, or <code>null</code> if not present
     */
    java.lang.Integer getBossThreads();
    
    /**
     * @return <code>java.lang.Integer</code> <code>workerThreads</code>, or <code>null</code> if not present
     */
    java.lang.Integer getWorkerThreads();

}

