package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ocp.radiohead.connection.provider.impl.rev150811.modules.module.configuration.ocp.radiohead.connection.provider.impl;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;
import java.util.HashMap;
import org.opendaylight.yangtools.concepts.Builder;
import java.util.Objects;
import java.util.Collections;
import java.util.Map;

/**
 * Class that builds {@link org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ocp.radiohead.connection.provider.impl.rev150811.modules.module.configuration.ocp.radiohead.connection.provider.impl.Threads} instances.
 *
 * @see org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ocp.radiohead.connection.provider.impl.rev150811.modules.module.configuration.ocp.radiohead.connection.provider.impl.Threads
 *
 */
public class ThreadsBuilder implements Builder<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ocp.radiohead.connection.provider.impl.rev150811.modules.module.configuration.ocp.radiohead.connection.provider.impl.Threads> {

    private java.lang.Integer _bossThreads;
    private java.lang.Integer _workerThreads;

    Map<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ocp.radiohead.connection.provider.impl.rev150811.modules.module.configuration.ocp.radiohead.connection.provider.impl.Threads>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ocp.radiohead.connection.provider.impl.rev150811.modules.module.configuration.ocp.radiohead.connection.provider.impl.Threads>> augmentation = Collections.emptyMap();

    public ThreadsBuilder() {
    }

    public ThreadsBuilder(Threads base) {
        this._bossThreads = base.getBossThreads();
        this._workerThreads = base.getWorkerThreads();
        if (base instanceof ThreadsImpl) {
            ThreadsImpl impl = (ThreadsImpl) base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            AugmentationHolder<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ocp.radiohead.connection.provider.impl.rev150811.modules.module.configuration.ocp.radiohead.connection.provider.impl.Threads> casted =(AugmentationHolder<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ocp.radiohead.connection.provider.impl.rev150811.modules.module.configuration.ocp.radiohead.connection.provider.impl.Threads>) base;
            if (!casted.augmentations().isEmpty()) {
                this.augmentation = new HashMap<>(casted.augmentations());
            }
        }
    }


    public java.lang.Integer getBossThreads() {
        return _bossThreads;
    }
    
    public java.lang.Integer getWorkerThreads() {
        return _workerThreads;
    }
    
    @SuppressWarnings("unchecked")
    public <E extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ocp.radiohead.connection.provider.impl.rev150811.modules.module.configuration.ocp.radiohead.connection.provider.impl.Threads>> E getAugmentation(java.lang.Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E) augmentation.get(augmentationType);
    }

     
     private static void checkBossThreadsRange(final int value) {
         if (value >= 0 && value <= 65535) {
             return;
         }
         throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0‥65535]].", value));
     }
    
    public ThreadsBuilder setBossThreads(final java.lang.Integer value) {
    if (value != null) {
        checkBossThreadsRange(value);
    }
        this._bossThreads = value;
        return this;
    }
    
     
     private static void checkWorkerThreadsRange(final int value) {
         if (value >= 0 && value <= 65535) {
             return;
         }
         throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0‥65535]].", value));
     }
    
    public ThreadsBuilder setWorkerThreads(final java.lang.Integer value) {
    if (value != null) {
        checkWorkerThreadsRange(value);
    }
        this._workerThreads = value;
        return this;
    }
    
    public ThreadsBuilder addAugmentation(java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ocp.radiohead.connection.provider.impl.rev150811.modules.module.configuration.ocp.radiohead.connection.provider.impl.Threads>> augmentationType, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ocp.radiohead.connection.provider.impl.rev150811.modules.module.configuration.ocp.radiohead.connection.provider.impl.Threads> augmentation) {
        if (augmentation == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    public ThreadsBuilder removeAugmentation(java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ocp.radiohead.connection.provider.impl.rev150811.modules.module.configuration.ocp.radiohead.connection.provider.impl.Threads>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public Threads build() {
        return new ThreadsImpl(this);
    }

    private static final class ThreadsImpl implements Threads {

        @Override
        public java.lang.Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ocp.radiohead.connection.provider.impl.rev150811.modules.module.configuration.ocp.radiohead.connection.provider.impl.Threads> getImplementedInterface() {
            return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ocp.radiohead.connection.provider.impl.rev150811.modules.module.configuration.ocp.radiohead.connection.provider.impl.Threads.class;
        }

        private final java.lang.Integer _bossThreads;
        private final java.lang.Integer _workerThreads;

        private Map<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ocp.radiohead.connection.provider.impl.rev150811.modules.module.configuration.ocp.radiohead.connection.provider.impl.Threads>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ocp.radiohead.connection.provider.impl.rev150811.modules.module.configuration.ocp.radiohead.connection.provider.impl.Threads>> augmentation = Collections.emptyMap();

        private ThreadsImpl(ThreadsBuilder base) {
            this._bossThreads = base.getBossThreads();
            this._workerThreads = base.getWorkerThreads();
            switch (base.augmentation.size()) {
            case 0:
                this.augmentation = Collections.emptyMap();
                break;
            case 1:
                final Map.Entry<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ocp.radiohead.connection.provider.impl.rev150811.modules.module.configuration.ocp.radiohead.connection.provider.impl.Threads>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ocp.radiohead.connection.provider.impl.rev150811.modules.module.configuration.ocp.radiohead.connection.provider.impl.Threads>> e = base.augmentation.entrySet().iterator().next();
                this.augmentation = Collections.<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ocp.radiohead.connection.provider.impl.rev150811.modules.module.configuration.ocp.radiohead.connection.provider.impl.Threads>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ocp.radiohead.connection.provider.impl.rev150811.modules.module.configuration.ocp.radiohead.connection.provider.impl.Threads>>singletonMap(e.getKey(), e.getValue());
                break;
            default :
                this.augmentation = new HashMap<>(base.augmentation);
            }
        }

        @Override
        public java.lang.Integer getBossThreads() {
            return _bossThreads;
        }
        
        @Override
        public java.lang.Integer getWorkerThreads() {
            return _workerThreads;
        }
        
        @SuppressWarnings("unchecked")
        @Override
        public <E extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ocp.radiohead.connection.provider.impl.rev150811.modules.module.configuration.ocp.radiohead.connection.provider.impl.Threads>> E getAugmentation(java.lang.Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E) augmentation.get(augmentationType);
        }

        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_bossThreads);
            result = prime * result + Objects.hashCode(_workerThreads);
            result = prime * result + Objects.hashCode(augmentation);
        
            hash = result;
            hashValid = true;
            return result;
        }

        @Override
        public boolean equals(java.lang.Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ocp.radiohead.connection.provider.impl.rev150811.modules.module.configuration.ocp.radiohead.connection.provider.impl.Threads.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ocp.radiohead.connection.provider.impl.rev150811.modules.module.configuration.ocp.radiohead.connection.provider.impl.Threads other = (org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ocp.radiohead.connection.provider.impl.rev150811.modules.module.configuration.ocp.radiohead.connection.provider.impl.Threads)obj;
            if (!Objects.equals(_bossThreads, other.getBossThreads())) {
                return false;
            }
            if (!Objects.equals(_workerThreads, other.getWorkerThreads())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                ThreadsImpl otherImpl = (ThreadsImpl) obj;
                if (!Objects.equals(augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ocp.radiohead.connection.provider.impl.rev150811.modules.module.configuration.ocp.radiohead.connection.provider.impl.Threads>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ocp.radiohead.connection.provider.impl.rev150811.modules.module.configuration.ocp.radiohead.connection.provider.impl.Threads>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.getAugmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        @Override
        public java.lang.String toString() {
            java.lang.String name = "Threads [";
            java.lang.StringBuilder builder = new java.lang.StringBuilder (name);
            if (_bossThreads != null) {
                builder.append("_bossThreads=");
                builder.append(_bossThreads);
                builder.append(", ");
            }
            if (_workerThreads != null) {
                builder.append("_workerThreads=");
                builder.append(_workerThreads);
            }
            final int builderLength = builder.length();
            final int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(augmentation.values());
            return builder.append(']').toString();
        }
    }

}
