package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ocp.radiohead.connection.provider.impl.rev150811.modules.module.configuration.ocp.radiohead.connection.provider.impl;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.config.rev150811.PathType;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.config.rev150811.KeystoreType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.rev130405.modules.Module;
import org.opendaylight.yangtools.yang.binding.Augmentable;

/**
 * <p>This class represents the following YANG schema fragment defined in module <b>ocp-radiohead-connection-provider-impl</b>
 * <pre>
 * container tls {
 *     leaf keystore {
 *         type string;
 *     }
 *     leaf keystore-type {
 *         type keystore-type;
 *     }
 *     leaf keystore-path-type {
 *         type path-type;
 *     }
 *     leaf keystore-password {
 *         type string;
 *     }
 *     leaf certificate-password {
 *         type string;
 *     }
 *     leaf truststore {
 *         type string;
 *     }
 *     leaf truststore-type {
 *         type keystore-type;
 *     }
 *     leaf truststore-path-type {
 *         type path-type;
 *     }
 *     leaf truststore-password {
 *         type string;
 *     }
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>ocp-radiohead-connection-provider-impl/modules/module/configuration/(urn:opendaylight:params:xml:ns:yang:ocp:radiohead:connection:provider:impl?revision=2015-08-11)ocp-radiohead-connection-provider-impl/tls</i>
 *
 * <p>To create instances of this class use {@link org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ocp.radiohead.connection.provider.impl.rev150811.modules.module.configuration.ocp.radiohead.connection.provider.impl.TlsBuilder}.
 * @see org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ocp.radiohead.connection.provider.impl.rev150811.modules.module.configuration.ocp.radiohead.connection.provider.impl.TlsBuilder
 *
 */
public interface Tls
    extends
    ChildOf<Module>,
    Augmentable<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ocp.radiohead.connection.provider.impl.rev150811.modules.module.configuration.ocp.radiohead.connection.provider.impl.Tls>
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:params:xml:ns:yang:ocp:radiohead:connection:provider:impl",
        "2015-08-11", "tls").intern();

    /**
     * keystore location
     *
     *
     *
     * @return <code>java.lang.String</code> <code>keystore</code>, or <code>null</code> if not present
     */
    java.lang.String getKeystore();
    
    /**
     * keystore type (JKS or PKCS12)
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.config.rev150811.KeystoreType</code> <code>keystoreType</code>, or <code>null</code> if not present
     */
    KeystoreType getKeystoreType();
    
    /**
     * keystore path type (CLASSPATH or PATH)
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.config.rev150811.PathType</code> <code>keystorePathType</code>, or <code>null</code> if not present
     */
    PathType getKeystorePathType();
    
    /**
     * password protecting keystore
     *
     *
     *
     * @return <code>java.lang.String</code> <code>keystorePassword</code>, or <code>null</code> if not present
     */
    java.lang.String getKeystorePassword();
    
    /**
     * password protecting certificate
     *
     *
     *
     * @return <code>java.lang.String</code> <code>certificatePassword</code>, or <code>null</code> if not present
     */
    java.lang.String getCertificatePassword();
    
    /**
     * truststore location
     *
     *
     *
     * @return <code>java.lang.String</code> <code>truststore</code>, or <code>null</code> if not present
     */
    java.lang.String getTruststore();
    
    /**
     * truststore type (JKS or PKCS12)
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.config.rev150811.KeystoreType</code> <code>truststoreType</code>, or <code>null</code> if not present
     */
    KeystoreType getTruststoreType();
    
    /**
     * truststore path type (CLASSPATH or PATH)
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.config.rev150811.PathType</code> <code>truststorePathType</code>, or <code>null</code> if not present
     */
    PathType getTruststorePathType();
    
    /**
     * password protecting truststore
     *
     *
     *
     * @return <code>java.lang.String</code> <code>truststorePassword</code>, or <code>null</code> if not present
     */
    java.lang.String getTruststorePassword();

}

