package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ocp.radiohead.connection.provider.impl.rev150811.modules.module.configuration.ocp.statistics.collection.service.impl;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;
import java.util.HashMap;
import org.opendaylight.yangtools.concepts.Builder;
import java.util.Objects;
import java.util.Collections;
import java.util.Map;

/**
 * Class that builds {@link org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ocp.radiohead.connection.provider.impl.rev150811.modules.module.configuration.ocp.statistics.collection.service.impl.OcpStatistics} instances.
 *
 * @see org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ocp.radiohead.connection.provider.impl.rev150811.modules.module.configuration.ocp.statistics.collection.service.impl.OcpStatistics
 *
 */
public class OcpStatisticsBuilder implements Builder<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ocp.radiohead.connection.provider.impl.rev150811.modules.module.configuration.ocp.statistics.collection.service.impl.OcpStatistics> {

    private java.lang.Integer _logReportDelay;
    private java.lang.Boolean _ocpStatisticsCollect;

    Map<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ocp.radiohead.connection.provider.impl.rev150811.modules.module.configuration.ocp.statistics.collection.service.impl.OcpStatistics>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ocp.radiohead.connection.provider.impl.rev150811.modules.module.configuration.ocp.statistics.collection.service.impl.OcpStatistics>> augmentation = Collections.emptyMap();

    public OcpStatisticsBuilder() {
    }

    public OcpStatisticsBuilder(OcpStatistics base) {
        this._logReportDelay = base.getLogReportDelay();
        this._ocpStatisticsCollect = base.isOcpStatisticsCollect();
        if (base instanceof OcpStatisticsImpl) {
            OcpStatisticsImpl impl = (OcpStatisticsImpl) base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            AugmentationHolder<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ocp.radiohead.connection.provider.impl.rev150811.modules.module.configuration.ocp.statistics.collection.service.impl.OcpStatistics> casted =(AugmentationHolder<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ocp.radiohead.connection.provider.impl.rev150811.modules.module.configuration.ocp.statistics.collection.service.impl.OcpStatistics>) base;
            if (!casted.augmentations().isEmpty()) {
                this.augmentation = new HashMap<>(casted.augmentations());
            }
        }
    }


    public java.lang.Integer getLogReportDelay() {
        return _logReportDelay;
    }
    
    public java.lang.Boolean isOcpStatisticsCollect() {
        return _ocpStatisticsCollect;
    }
    
    @SuppressWarnings("unchecked")
    public <E extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ocp.radiohead.connection.provider.impl.rev150811.modules.module.configuration.ocp.statistics.collection.service.impl.OcpStatistics>> E getAugmentation(java.lang.Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E) augmentation.get(augmentationType);
    }

     
     private static void checkLogReportDelayRange(final int value) {
         if (value >= 0 && value <= 65535) {
             return;
         }
         throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0‥65535]].", value));
     }
    
    public OcpStatisticsBuilder setLogReportDelay(final java.lang.Integer value) {
    if (value != null) {
        checkLogReportDelayRange(value);
    }
        this._logReportDelay = value;
        return this;
    }
    
     
    public OcpStatisticsBuilder setOcpStatisticsCollect(final java.lang.Boolean value) {
        this._ocpStatisticsCollect = value;
        return this;
    }
    
    public OcpStatisticsBuilder addAugmentation(java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ocp.radiohead.connection.provider.impl.rev150811.modules.module.configuration.ocp.statistics.collection.service.impl.OcpStatistics>> augmentationType, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ocp.radiohead.connection.provider.impl.rev150811.modules.module.configuration.ocp.statistics.collection.service.impl.OcpStatistics> augmentation) {
        if (augmentation == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    public OcpStatisticsBuilder removeAugmentation(java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ocp.radiohead.connection.provider.impl.rev150811.modules.module.configuration.ocp.statistics.collection.service.impl.OcpStatistics>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public OcpStatistics build() {
        return new OcpStatisticsImpl(this);
    }

    private static final class OcpStatisticsImpl implements OcpStatistics {

        @Override
        public java.lang.Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ocp.radiohead.connection.provider.impl.rev150811.modules.module.configuration.ocp.statistics.collection.service.impl.OcpStatistics> getImplementedInterface() {
            return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ocp.radiohead.connection.provider.impl.rev150811.modules.module.configuration.ocp.statistics.collection.service.impl.OcpStatistics.class;
        }

        private final java.lang.Integer _logReportDelay;
        private final java.lang.Boolean _ocpStatisticsCollect;

        private Map<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ocp.radiohead.connection.provider.impl.rev150811.modules.module.configuration.ocp.statistics.collection.service.impl.OcpStatistics>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ocp.radiohead.connection.provider.impl.rev150811.modules.module.configuration.ocp.statistics.collection.service.impl.OcpStatistics>> augmentation = Collections.emptyMap();

        private OcpStatisticsImpl(OcpStatisticsBuilder base) {
            this._logReportDelay = base.getLogReportDelay();
            this._ocpStatisticsCollect = base.isOcpStatisticsCollect();
            switch (base.augmentation.size()) {
            case 0:
                this.augmentation = Collections.emptyMap();
                break;
            case 1:
                final Map.Entry<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ocp.radiohead.connection.provider.impl.rev150811.modules.module.configuration.ocp.statistics.collection.service.impl.OcpStatistics>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ocp.radiohead.connection.provider.impl.rev150811.modules.module.configuration.ocp.statistics.collection.service.impl.OcpStatistics>> e = base.augmentation.entrySet().iterator().next();
                this.augmentation = Collections.<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ocp.radiohead.connection.provider.impl.rev150811.modules.module.configuration.ocp.statistics.collection.service.impl.OcpStatistics>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ocp.radiohead.connection.provider.impl.rev150811.modules.module.configuration.ocp.statistics.collection.service.impl.OcpStatistics>>singletonMap(e.getKey(), e.getValue());
                break;
            default :
                this.augmentation = new HashMap<>(base.augmentation);
            }
        }

        @Override
        public java.lang.Integer getLogReportDelay() {
            return _logReportDelay;
        }
        
        @Override
        public java.lang.Boolean isOcpStatisticsCollect() {
            return _ocpStatisticsCollect;
        }
        
        @SuppressWarnings("unchecked")
        @Override
        public <E extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ocp.radiohead.connection.provider.impl.rev150811.modules.module.configuration.ocp.statistics.collection.service.impl.OcpStatistics>> E getAugmentation(java.lang.Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E) augmentation.get(augmentationType);
        }

        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_logReportDelay);
            result = prime * result + Objects.hashCode(_ocpStatisticsCollect);
            result = prime * result + Objects.hashCode(augmentation);
        
            hash = result;
            hashValid = true;
            return result;
        }

        @Override
        public boolean equals(java.lang.Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ocp.radiohead.connection.provider.impl.rev150811.modules.module.configuration.ocp.statistics.collection.service.impl.OcpStatistics.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ocp.radiohead.connection.provider.impl.rev150811.modules.module.configuration.ocp.statistics.collection.service.impl.OcpStatistics other = (org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ocp.radiohead.connection.provider.impl.rev150811.modules.module.configuration.ocp.statistics.collection.service.impl.OcpStatistics)obj;
            if (!Objects.equals(_logReportDelay, other.getLogReportDelay())) {
                return false;
            }
            if (!Objects.equals(_ocpStatisticsCollect, other.isOcpStatisticsCollect())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                OcpStatisticsImpl otherImpl = (OcpStatisticsImpl) obj;
                if (!Objects.equals(augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ocp.radiohead.connection.provider.impl.rev150811.modules.module.configuration.ocp.statistics.collection.service.impl.OcpStatistics>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ocp.radiohead.connection.provider.impl.rev150811.modules.module.configuration.ocp.statistics.collection.service.impl.OcpStatistics>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.getAugmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        @Override
        public java.lang.String toString() {
            java.lang.String name = "OcpStatistics [";
            java.lang.StringBuilder builder = new java.lang.StringBuilder (name);
            if (_logReportDelay != null) {
                builder.append("_logReportDelay=");
                builder.append(_logReportDelay);
                builder.append(", ");
            }
            if (_ocpStatisticsCollect != null) {
                builder.append("_ocpStatisticsCollect=");
                builder.append(_ocpStatisticsCollect);
            }
            final int builderLength = builder.length();
            final int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(augmentation.values());
            return builder.append(']').toString();
        }
    }

}
