/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.ocpjava.protocol.impl.core;

import java.io.IOException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.Security;
import java.security.cert.CertificateException;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.opendaylight.ocpjava.protocol.api.connection.TlsConfiguration;
import org.opendaylight.ocpjava.protocol.impl.core.SslKeyStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SslContextFactory {
    private static final String PROTOCOL = "TLS";
    private TlsConfiguration tlsConfig;
    private static final Logger LOGGER = LoggerFactory.getLogger(SslContextFactory.class);

    public SslContextFactory(TlsConfiguration tlsConfig) {
        this.tlsConfig = tlsConfig;
    }

    public SSLContext getServerContext() {
        String algorithm = Security.getProperty("ssl.KeyManagerFactory.algorithm");
        if (algorithm == null) {
            algorithm = "SunX509";
        }
        SSLContext serverContext = null;
        try {
            KeyStore ks = KeyStore.getInstance(this.tlsConfig.getTlsKeystoreType().name());
            ks.load(SslKeyStore.asInputStream(this.tlsConfig.getTlsKeystore(), this.tlsConfig.getTlsKeystorePathType()), this.tlsConfig.getKeystorePassword().toCharArray());
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(algorithm);
            kmf.init(ks, this.tlsConfig.getCertificatePassword().toCharArray());
            KeyStore ts = KeyStore.getInstance(this.tlsConfig.getTlsTruststoreType().name());
            ts.load(SslKeyStore.asInputStream(this.tlsConfig.getTlsTruststore(), this.tlsConfig.getTlsTruststorePathType()), this.tlsConfig.getTruststorePassword().toCharArray());
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(algorithm);
            tmf.init(ts);
            serverContext = SSLContext.getInstance(PROTOCOL);
            serverContext.init(kmf.getKeyManagers(), tmf.getTrustManagers(), null);
        }
        catch (IOException e) {
            LOGGER.warn("IOException - Failed to load keystore / truststore. Failed to initialize the server-side SSLContext", (Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            LOGGER.warn("NoSuchAlgorithmException - Unsupported algorithm. Failed to initialize the server-side SSLContext", (Throwable)e);
        }
        catch (CertificateException e) {
            LOGGER.warn("CertificateException - Unable to access certificate (check password). Failed to initialize the server-side SSLContext", (Throwable)e);
        }
        catch (Exception e) {
            LOGGER.warn("Exception - Failed to initialize the server-side SSLContext", (Throwable)e);
        }
        return serverContext;
    }
}

