/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.ocpjava.protocol.impl.core.connection;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.FutureCallback;
import org.opendaylight.ocpjava.protocol.api.connection.OutboundQueueException;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.OcpHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class OutboundQueueEntry {
    private static final Logger LOG = LoggerFactory.getLogger(OutboundQueueEntry.class);
    private FutureCallback<OcpHeader> callback;
    private OcpHeader message;
    private boolean completed;
    private volatile boolean committed;

    OutboundQueueEntry() {
    }

    void commit(OcpHeader message, FutureCallback<OcpHeader> callback) {
        this.message = message;
        this.callback = callback;
        this.committed = true;
    }

    void reset() {
        this.callback = null;
        this.completed = false;
        this.message = null;
        this.committed = false;
    }

    boolean isCommitted() {
        return this.committed;
    }

    boolean isCompleted() {
        return this.completed;
    }

    OcpHeader takeMessage() {
        OcpHeader ret = this.message;
        this.message = null;
        return ret;
    }

    boolean complete(OcpHeader response) {
        Preconditions.checkState((!this.completed ? 1 : 0) != 0, (String)"Attempted to complete a completed message with response %s", (Object[])new Object[]{response});
        boolean reallyComplete = true;
        this.completed = true;
        if (this.callback != null) {
            this.callback.onSuccess((Object)response);
            this.callback = null;
        }
        LOG.debug("Entry {} completed {} with response {}", new Object[]{this, this.completed, response});
        return true;
    }

    void fail(OutboundQueueException cause) {
        if (!this.completed) {
            this.completed = true;
            if (this.callback != null) {
                this.callback.onFailure((Throwable)cause);
                this.callback = null;
            }
        } else {
            LOG.warn("Ignoring failure {} for completed message", (Throwable)cause);
        }
    }
}

