/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.ocpjava.protocol.impl.core.connection;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.util.concurrent.FutureCallback;
import io.netty.channel.Channel;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.GuardedBy;
import org.opendaylight.ocpjava.protocol.api.connection.OutboundQueue;
import org.opendaylight.ocpjava.protocol.api.connection.OutboundQueueException;
import org.opendaylight.ocpjava.protocol.impl.core.connection.OutboundQueueEntry;
import org.opendaylight.ocpjava.protocol.impl.core.connection.OutboundQueueManager;
import org.opendaylight.ocpjava.protocol.impl.core.connection.StackedSegment;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.OcpHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class StackedOutboundQueue
implements OutboundQueue {
    private static final Logger LOG = LoggerFactory.getLogger(StackedOutboundQueue.class);
    private static final AtomicLongFieldUpdater<StackedOutboundQueue> LAST_XID_UPDATER = AtomicLongFieldUpdater.newUpdater(StackedOutboundQueue.class, "lastXid");
    @GuardedBy(value="unflushedSegments")
    private volatile StackedSegment firstSegment;
    @GuardedBy(value="unflushedSegments")
    private final List<StackedSegment> unflushedSegments = new ArrayList<StackedSegment>(2);
    @GuardedBy(value="unflushedSegments")
    private final List<StackedSegment> uncompletedSegments = new ArrayList<StackedSegment>(2);
    private final OutboundQueueManager<?> manager;
    private volatile long allocatedXid = -1L;
    private volatile long lastXid = -1L;
    @GuardedBy(value="unflushedSegments")
    private Integer shutdownOffset;
    private boolean oneMsgOutgoing;
    private Timer timer;
    private TimerTask timerTask;
    private static final int respTimeOut = 15000;
    private int flushOffset;

    StackedOutboundQueue(OutboundQueueManager<?> manager) {
        this.manager = (OutboundQueueManager)Preconditions.checkNotNull(manager);
        this.firstSegment = StackedSegment.create(0L);
        this.uncompletedSegments.add(this.firstSegment);
        this.unflushedSegments.add(this.firstSegment);
        this.oneMsgOutgoing = false;
    }

    @GuardedBy(value="unflushedSegments")
    private void ensureSegment(StackedSegment first, int offset) {
        int segmentOffset = offset / 4096;
        LOG.debug("Queue {} slow offset {} maps to {} segments {}", new Object[]{this, offset, segmentOffset, this.unflushedSegments.size()});
        for (int i = this.unflushedSegments.size(); i <= segmentOffset; ++i) {
            StackedSegment newSegment = StackedSegment.create(first.getBaseXid() + (long)(4096 * i));
            LOG.debug("Adding segment {}", (Object)newSegment);
            this.unflushedSegments.add(newSegment);
        }
        this.allocatedXid = this.uncompletedSegments.get(this.uncompletedSegments.size() - 1).getEndXid();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long reserveEntry() {
        StackedSegment fastSegment;
        long xid = LAST_XID_UPDATER.incrementAndGet(this);
        if (xid >= (fastSegment = this.firstSegment).getBaseXid() + 4096L) {
            if (xid >= this.allocatedXid) {
                LOG.debug("Queue {} falling back to slow reservation for XID {}", (Object)this, (Object)xid);
                List<StackedSegment> list = this.unflushedSegments;
                synchronized (list) {
                    LOG.debug("Queue {} executing slow reservation for XID {}", (Object)this, (Object)xid);
                    if (this.shutdownOffset != null) {
                        LOG.debug("Queue {} is being shutdown, failing reservation", (Object)this);
                        return null;
                    }
                    StackedSegment slowSegment = this.firstSegment;
                    int slowOffset = (int)(xid - slowSegment.getBaseXid());
                    Verify.verify((slowOffset >= 0 ? 1 : 0) != 0);
                    this.ensureSegment(slowSegment, slowOffset);
                    LOG.debug("Queue {} slow reservation finished", (Object)this);
                }
            } else {
                LOG.debug("Queue {} XID {} is already backed", (Object)this, (Object)xid);
            }
        }
        LOG.trace("Queue {} allocated XID {}", (Object)this, (Object)xid);
        return xid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commitEntry(Long xid, OcpHeader message, FutureCallback<OcpHeader> callback) {
        OutboundQueueEntry entry;
        StackedSegment fastSegment = this.firstSegment;
        long calcOffset = xid - fastSegment.getBaseXid();
        Preconditions.checkArgument((calcOffset >= 0L ? 1 : 0) != 0, (String)"Commit of XID %s does not match up with base XID %s", (Object[])new Object[]{xid, fastSegment.getBaseXid()});
        Verify.verify((calcOffset <= Integer.MAX_VALUE ? 1 : 0) != 0);
        int fastOffset = (int)calcOffset;
        if (fastOffset >= 4096) {
            StackedSegment segment;
            int slowOffset;
            LOG.debug("Queue {} falling back to slow commit of XID {} at offset {}", new Object[]{this, xid, fastOffset});
            List<StackedSegment> list = this.unflushedSegments;
            synchronized (list) {
                StackedSegment slowSegment = this.firstSegment;
                long slowCalcOffset = xid - slowSegment.getBaseXid();
                Verify.verify((slowCalcOffset >= 0L && slowCalcOffset <= Integer.MAX_VALUE ? 1 : 0) != 0);
                slowOffset = (int)slowCalcOffset;
                LOG.debug("Queue {} recalculated offset of XID {} to {}", new Object[]{this, xid, slowOffset});
                segment = this.unflushedSegments.get(slowOffset / 4096);
            }
            int segOffset = slowOffset % 4096;
            entry = segment.getEntry(segOffset);
            LOG.debug("Queue {} slow commit of XID {} completed at offset {} (segment {} offset {})", new Object[]{this, xid, slowOffset, segment, segOffset});
        } else {
            entry = fastSegment.getEntry(fastOffset);
        }
        entry.commit(message, callback);
        LOG.trace("Queue {} committed XID {}", (Object)this, (Object)xid);
        this.manager.ensureFlushing();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int writeEntries(@Nonnull Channel channel, long now) {
        StackedSegment segment = this.firstSegment;
        int entries = 0;
        while (channel.isWritable() && !this.getOneMsgOutgoing()) {
            OutboundQueueEntry entry = segment.getEntry(this.flushOffset);
            if (!entry.isCommitted()) {
                LOG.debug("Queue {} XID {} segment {} offset {} not committed yet", new Object[]{this, segment.getBaseXid() + (long)this.flushOffset, segment, this.flushOffset});
                break;
            }
            LOG.trace("Queue {} flushing entry at offset {}", (Object)this, (Object)this.flushOffset);
            final OcpHeader message = entry.takeMessage();
            ++this.flushOffset;
            ++entries;
            if (message != null) {
                this.manager.writeMessage(message, now);
            } else {
                entry.complete(null);
            }
            if (this.flushOffset >= 4096) {
                List<StackedSegment> list = this.unflushedSegments;
                synchronized (list) {
                    LOG.debug("Flush offset {} unflushed segments {}", (Object)this.flushOffset, (Object)this.unflushedSegments.size());
                    this.ensureSegment(segment, this.flushOffset);
                    StackedSegment oldSegment = this.unflushedSegments.remove(0);
                    if (oldSegment.isComplete()) {
                        this.uncompletedSegments.remove(oldSegment);
                        oldSegment.recycle();
                    }
                    segment = this.unflushedSegments.get(0);
                    this.uncompletedSegments.add(segment);
                    if (this.shutdownOffset != null) {
                        this.shutdownOffset = this.shutdownOffset - 4096;
                    }
                    this.firstSegment = segment;
                    this.flushOffset = 0;
                    LOG.debug("Queue {} flush moved to segment {}", (Object)this, (Object)segment);
                }
            }
            this.setOneMsgOutgoing(true);
            this.timer = new Timer();
            this.timerTask = new TimerTask(){

                @Override
                public void run() {
                    LOG.error("Timeout, no resp of msg = {}, msg Xid = {}", (Object)message, (Object)message.getXid());
                    StackedOutboundQueue.this.timer.cancel();
                    StackedOutboundQueue.this.timer.purge();
                    StackedOutboundQueue.this.setOneMsgOutgoing(false);
                }
            };
            LOG.debug("Timer countDown");
            this.timer.schedule(this.timerTask, 15000L);
        }
        return entries;
    }

    boolean pairRequest(OcpHeader message) {
        Iterator<StackedSegment> it = this.uncompletedSegments.iterator();
        while (it.hasNext()) {
            StackedSegment queue = it.next();
            OutboundQueueEntry entry = queue.pairRequest(message);
            if (entry == null) continue;
            LOG.trace("Queue {} accepted response {}", (Object)queue, (Object)message);
            if (queue.isComplete()) {
                LOG.trace("Queue {} is finished", (Object)queue);
                it.remove();
                queue.recycle();
            }
            LOG.trace("Received resp, permit another outGoing message");
            this.timer.cancel();
            this.timer.purge();
            this.setOneMsgOutgoing(false);
            return true;
        }
        LOG.debug("Failed to find completion for message {}", (Object)message);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long startShutdown(Channel channel) {
        List<StackedSegment> list = this.unflushedSegments;
        synchronized (list) {
            long xid = LAST_XID_UPDATER.addAndGet(this, 4096L);
            this.shutdownOffset = (int)(xid - this.firstSegment.getBaseXid() - 4096L);
            return this.lockedShutdownFlush();
        }
    }

    @GuardedBy(value="unflushedSegments")
    private long lockedShutdownFlush() {
        long entries = 0L;
        Iterator<StackedSegment> it = this.uncompletedSegments.iterator();
        while (it.hasNext()) {
            StackedSegment segment = it.next();
            entries += (long)segment.failAll(OutboundQueueException.DEVICE_DISCONNECTED);
            if (!segment.isComplete()) continue;
            LOG.trace("Cleared segment {}", (Object)segment);
            it.remove();
        }
        return entries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean finishShutdown() {
        List<StackedSegment> list = this.unflushedSegments;
        synchronized (list) {
            this.lockedShutdownFlush();
        }
        return !this.needsFlush();
    }

    boolean needsFlush() {
        if (this.firstSegment.getBaseXid() + (long)this.flushOffset > this.lastXid) {
            return false;
        }
        if (this.shutdownOffset != null && this.flushOffset >= this.shutdownOffset) {
            return false;
        }
        return this.firstSegment.getEntry(this.flushOffset).isCommitted();
    }

    boolean getOneMsgOutgoing() {
        return this.oneMsgOutgoing;
    }

    void setOneMsgOutgoing(boolean oneMsgOutgoing) {
        LOG.debug("oneMsgOutgoing = {}", (Object)oneMsgOutgoing);
        this.oneMsgOutgoing = oneMsgOutgoing;
    }
}

