/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.ocpjava.protocol.impl.deserialization;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opendaylight.ocpjava.protocol.api.extensibility.DeserializerRegistry;
import org.opendaylight.ocpjava.protocol.api.extensibility.OCPDeserializer;
import org.opendaylight.ocpjava.protocol.api.keys.MessageCodeKey;
import org.opendaylight.ocpjava.protocol.impl.deserialization.TypeToClassMapInitializer;
import org.opendaylight.ocpjava.protocol.impl.util.TypeToClassKey;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeserializationFactory {
    private final Map<TypeToClassKey, Class<?>> messageClassMap;
    private DeserializerRegistry registry;
    private static final Logger LOGGER = LoggerFactory.getLogger(DeserializationFactory.class);

    public DeserializationFactory() {
        HashMap temp = new HashMap();
        TypeToClassMapInitializer.initializeTypeToClassMap(temp);
        this.messageClassMap = ImmutableMap.copyOf(temp);
        LOGGER.trace("DeserializationFactory: messageClassMap = " + this.messageClassMap);
    }

    public DataObject deserialize(short version, int type, List<Object> rawMessage) {
        DataObject dataObject = null;
        Class<?> clazz = this.messageClassMap.get(new TypeToClassKey(version, type));
        OCPDeserializer deserializer = (OCPDeserializer)this.registry.getDeserializer(new MessageCodeKey(version, type, clazz));
        dataObject = deserializer.deserialize(rawMessage);
        return dataObject;
    }

    public void setRegistry(DeserializerRegistry registry) {
        this.registry = registry;
    }
}

