/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.ocpjava.protocol.impl.deserialization.factories;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.opendaylight.ocpjava.protocol.api.extensibility.OCPDeserializer;
import org.opendaylight.ocpjava.protocol.impl.core.XmlCharacters;
import org.opendaylight.ocpjava.protocol.impl.core.XmlElementEnd;
import org.opendaylight.ocpjava.protocol.impl.core.XmlElementStart;
import org.opendaylight.ocpjava.protocol.impl.deserialization.factories.utils.MessageHelper;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.CreateObjGlobRes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.CreateObjRes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.ObjId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.OcpMsgType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.createobjoutput.Param;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.createobjoutput.ParamBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.protocol.rev150811.CreateObjOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.protocol.rev150811.CreateObjOutputBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateObjOutputFactory
implements OCPDeserializer<CreateObjOutput> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CreateObjOutputFactory.class);

    public CreateObjOutput deserialize(List<Object> rawMessage) {
        CreateObjOutputBuilder builder = new CreateObjOutputBuilder();
        Iterator<Object> itr = rawMessage.iterator();
        while (itr.hasNext()) {
            Object tok = itr.next();
            LOGGER.trace("CreateObjOutputFactory - itr = " + tok);
            try {
                if (!(tok instanceof XmlElementStart)) continue;
                if (((XmlElementStart)tok).name().equals("body")) {
                    String type = MessageHelper.getMsgType(itr);
                    builder.setMsgType(OcpMsgType.valueOf((String)type));
                    continue;
                }
                if (((XmlElementStart)tok).name().equals("msgUID")) {
                    String uidStr = MessageHelper.getMsgUID(itr);
                    int uid = Integer.parseInt(uidStr);
                    builder.setXid(Long.valueOf(uid));
                    continue;
                }
                if (((XmlElementStart)tok).name().equals("globResult")) {
                    String gloRel = MessageHelper.getResult(itr);
                    builder.setGlobResult(CreateObjGlobRes.valueOf((String)gloRel));
                    continue;
                }
                if (!((XmlElementStart)tok).name().equals("obj")) continue;
                if (((XmlElementStart)tok).attributes().size() >= 1) {
                    builder.setObjId(new ObjId(((XmlElementStart)tok).attributes().get(0).value()));
                }
                builder.setParam(this.getListParam(itr));
                LOGGER.trace("CreateObjOutputFactory - builder.getParam() " + builder.getParam());
            }
            catch (Exception t) {
                LOGGER.error("Error {} ", tok, (Object)t);
            }
        }
        LOGGER.info("CreateObjOutputFactory - Builder: " + builder.build());
        return builder.build();
    }

    public List<Param> getListParam(Iterator itr) {
        ParamBuilder parambuilder = new ParamBuilder();
        ArrayList<Param> plist = new ArrayList<Param>();
        Object tok = this.findNextParamObj(itr);
        if (tok instanceof XmlElementStart) {
            while (!((XmlElementStart)tok).name().equals("obj")) {
                if (!((XmlElementStart)tok).name().equals("param")) continue;
                parambuilder.setName(((XmlElementStart)tok).attributes().get(0).value());
                Object result = this.findNextResultObj(itr);
                if (((XmlElementStart)result).name().equals("result")) {
                    tok = itr.next();
                    String rel = "";
                    while (tok instanceof XmlCharacters) {
                        rel = rel.concat(((XmlCharacters)tok).data().toString().replace("_", ""));
                        LOGGER.debug("CreateObjOutputFactory - result = {}", (Object)((XmlCharacters)tok).data().toString().replace("_", ""));
                        tok = itr.next();
                    }
                    parambuilder.setResult(CreateObjRes.valueOf((String)rel));
                } else {
                    tok = itr.next();
                }
                LOGGER.debug("CreateObjOutputFactory - parambuilder.build() " + parambuilder.build());
                plist.add(parambuilder.build());
                parambuilder = new ParamBuilder();
                while (!(!(tok instanceof XmlElementStart) && !(tok instanceof XmlElementEnd) && !(tok instanceof XmlCharacters) || tok instanceof XmlElementStart && ((XmlElementStart)tok).name().equals("param") || tok instanceof XmlElementEnd && ((XmlElementEnd)tok).name().equals("obj"))) {
                    tok = itr.next();
                }
                if (!(tok instanceof XmlElementEnd) || !((XmlElementEnd)tok).name().equals("obj")) continue;
                break;
            }
        }
        return plist;
    }

    public Object findNextParamObj(Iterator itr) {
        Object tok = itr.next();
        while (!(tok instanceof XmlElementStart || tok instanceof XmlElementEnd && ((XmlElementEnd)tok).name().equals("obj"))) {
            tok = itr.next();
        }
        return tok;
    }

    public Object findNextResultObj(Iterator itr) {
        Object tok = itr.next();
        while (!(tok instanceof XmlElementStart)) {
            tok = itr.next();
        }
        return tok;
    }
}

