/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.ocpjava.protocol.impl.deserialization.factories;

import java.util.Iterator;
import java.util.List;
import org.opendaylight.ocpjava.protocol.api.extensibility.OCPDeserializer;
import org.opendaylight.ocpjava.protocol.impl.core.XmlElementStart;
import org.opendaylight.ocpjava.protocol.impl.deserialization.factories.utils.MessageHelper;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.DeleteObjRes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.OcpMsgType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.protocol.rev150811.DeleteObjOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.protocol.rev150811.DeleteObjOutputBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteObjOutputFactory
implements OCPDeserializer<DeleteObjOutput> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DeleteObjOutputFactory.class);

    public DeleteObjOutput deserialize(List<Object> rawMessage) {
        DeleteObjOutputBuilder builder = new DeleteObjOutputBuilder();
        Iterator<Object> itr = rawMessage.iterator();
        while (itr.hasNext()) {
            Object tok = itr.next();
            LOGGER.trace("DeleteObjOutputFactory - itr = " + tok);
            try {
                if (!(tok instanceof XmlElementStart)) continue;
                if (((XmlElementStart)tok).name().equals("body")) {
                    String typeStr = MessageHelper.getMsgType(itr);
                    builder.setMsgType(OcpMsgType.valueOf((String)typeStr));
                    continue;
                }
                if (((XmlElementStart)tok).name().equals("msgUID")) {
                    String uidStr = MessageHelper.getMsgUID(itr);
                    int uid = Integer.parseInt(uidStr);
                    builder.setXid(Long.valueOf(uid));
                    continue;
                }
                if (!((XmlElementStart)tok).name().equals("result")) continue;
                String rel = MessageHelper.getResult(itr);
                builder.setResult(DeleteObjRes.valueOf((String)rel));
            }
            catch (Exception t) {
                LOGGER.error("Error " + tok + " " + t.toString());
            }
        }
        LOGGER.debug("DeleteObjOutputFactory - Builder: " + builder.build());
        return builder.build();
    }
}

