/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.ocpjava.protocol.impl.deserialization.factories;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.opendaylight.ocpjava.protocol.api.extensibility.OCPDeserializer;
import org.opendaylight.ocpjava.protocol.impl.core.XmlCharacters;
import org.opendaylight.ocpjava.protocol.impl.core.XmlElementEnd;
import org.opendaylight.ocpjava.protocol.impl.core.XmlElementStart;
import org.opendaylight.ocpjava.protocol.impl.deserialization.factories.utils.MessageHelper;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.FaultId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.FaultSeverity;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.GetFaultRes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.ObjId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.OcpMsgType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.getfaultoutput.Obj;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.getfaultoutput.ObjBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.getfaultoutput.obj.Fault;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.getfaultoutput.obj.FaultBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.protocol.rev150811.GetFaultOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.protocol.rev150811.GetFaultOutputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.xsd.types.rev150811.XsdDateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetFaultOutputFactory
implements OCPDeserializer<GetFaultOutput> {
    private static final Logger LOGGER = LoggerFactory.getLogger(GetFaultOutputFactory.class);
    private String faultTag = "fault";

    public GetFaultOutput deserialize(List<Object> rawMessage) {
        GetFaultOutputBuilder builder = new GetFaultOutputBuilder();
        ObjBuilder objbuilder = new ObjBuilder();
        FaultBuilder faultbuilder = new FaultBuilder();
        ArrayList<Fault> fault = new ArrayList<Fault>();
        ArrayList<Obj> obj = new ArrayList<Obj>();
        Iterator<Object> itr = rawMessage.iterator();
        while (itr.hasNext()) {
            Object tok = itr.next();
            LOGGER.trace("GetFaultOutputFactory - itr = " + tok);
            try {
                if (!(tok instanceof XmlElementStart)) continue;
                if (((XmlElementStart)tok).name().equals("body")) {
                    String type = MessageHelper.getMsgType(itr);
                    builder.setMsgType(OcpMsgType.valueOf((String)type));
                    continue;
                }
                if (((XmlElementStart)tok).name().equals("msgUID")) {
                    String uidStr = MessageHelper.getMsgUID(itr);
                    int uid = Integer.parseInt(uidStr);
                    builder.setXid(Long.valueOf(uid));
                    continue;
                }
                if (((XmlElementStart)tok).name().equals("result")) {
                    String rel = MessageHelper.getResult(itr);
                    builder.setResult(GetFaultRes.valueOf((String)rel));
                    LOGGER.trace("GetFaultOutputFactory - getResult: " + builder.getResult());
                    continue;
                }
                if (!((XmlElementStart)tok).name().equals("obj")) continue;
                objbuilder.setId(new ObjId(((XmlElementStart)tok).attributes().get(0).value()));
                LOGGER.trace("GetFaultOutputFactory - objbuilder getId: " + objbuilder.getId());
                Object faulttok = itr.next();
                while (!(faulttok instanceof XmlElementStart || faulttok instanceof XmlElementEnd && ((XmlElementEnd)faulttok).name().equals("obj"))) {
                    faulttok = itr.next();
                }
                if (faulttok instanceof XmlElementStart) {
                    while (!((XmlElementStart)faulttok).name().equals("obj")) {
                        if (((XmlElementStart)faulttok).name().equals(this.faultTag)) {
                            faulttok = itr.next();
                            while (!(faulttok instanceof XmlElementStart || faulttok instanceof XmlElementEnd && ((XmlElementEnd)faulttok).name().equals(this.faultTag))) {
                                faulttok = itr.next();
                            }
                            if (faulttok instanceof XmlElementStart) {
                                ArrayList<String> affecttok = new ArrayList<String>();
                                while (!((XmlElementStart)faulttok).name().equals(this.faultTag)) {
                                    String bufStr;
                                    if (((XmlElementStart)faulttok).name().equals("faultID")) {
                                        bufStr = MessageHelper.getCharVal(itr);
                                        faultbuilder.setId(FaultId.valueOf((String)bufStr));
                                    } else if (((XmlElementStart)faulttok).name().equals("severity")) {
                                        bufStr = MessageHelper.getCharVal(itr);
                                        faultbuilder.setSeverity(FaultSeverity.valueOf((String)bufStr));
                                    } else if (((XmlElementStart)faulttok).name().equals("timestamp")) {
                                        bufStr = MessageHelper.getCharVal(itr);
                                        faultbuilder.setTimestamp(new XsdDateTime(bufStr));
                                    } else if (((XmlElementStart)faulttok).name().equals("descr")) {
                                        faulttok = itr.next();
                                        StringBuilder buf = new StringBuilder();
                                        while (faulttok instanceof XmlCharacters) {
                                            buf.append(((XmlCharacters)faulttok).data().toString());
                                            faulttok = itr.next();
                                        }
                                        faultbuilder.setDescr(buf.toString());
                                    } else if (((XmlElementStart)faulttok).name().equals("affectedObj")) {
                                        bufStr = MessageHelper.getCharVal(itr);
                                        affecttok.add(bufStr);
                                        faultbuilder.setAffectedObj(affecttok);
                                    } else {
                                        faulttok = itr.next();
                                        while (faulttok instanceof XmlCharacters) {
                                            faulttok = itr.next();
                                        }
                                    }
                                    faulttok = itr.next();
                                    while (!(faulttok instanceof XmlElementStart || faulttok instanceof XmlElementEnd && ((XmlElementEnd)faulttok).name().equals(this.faultTag))) {
                                        faulttok = itr.next();
                                    }
                                    if (!(faulttok instanceof XmlElementEnd)) continue;
                                    LOGGER.trace("GetFaultOutputFactory - found XmlElementEnd: {}", faulttok);
                                    if (!((XmlElementEnd)faulttok).name().equals(this.faultTag)) continue;
                                    faulttok = itr.next();
                                    while (faulttok instanceof XmlCharacters) {
                                        faulttok = itr.next();
                                    }
                                    break;
                                }
                            } else if (faulttok instanceof XmlElementEnd && ((XmlElementEnd)faulttok).name().equals(this.faultTag)) {
                                LOGGER.debug("GetFaultOutputFactory - No Fault happened");
                                faulttok = itr.next();
                                while (!(faulttok instanceof XmlElementStart || faulttok instanceof XmlElementEnd && ((XmlElementEnd)faulttok).name().equals("obj"))) {
                                    faulttok = itr.next();
                                }
                            }
                            LOGGER.trace("GetFaultOutputFactory - faultbuilder = " + faultbuilder.build());
                            fault.add(faultbuilder.build());
                            faultbuilder = new FaultBuilder();
                        }
                        if (faulttok instanceof XmlElementEnd) {
                            LOGGER.trace("GetFaultOutputFactory - found XmlElementEnd: {}", faulttok);
                            if (((XmlElementEnd)faulttok).name().equals("obj")) break;
                        }
                        while (!(faulttok instanceof XmlElementStart)) {
                            faulttok = itr.next();
                        }
                    }
                } else if (faulttok instanceof XmlElementEnd && ((XmlElementEnd)faulttok).name().equals("obj")) {
                    LOGGER.info("GetFaultOutputFactory - No fault obj return");
                }
                objbuilder.setFault(fault);
                LOGGER.trace("GetFaultOutputFactory - objbuilder getObj = " + objbuilder.build());
                obj.add(objbuilder.build());
            }
            catch (Exception t) {
                LOGGER.error("Error " + tok + " " + t.toString());
            }
        }
        builder.setObj(obj);
        LOGGER.debug("GetFaultOutputFactory - Builder: " + builder.build());
        return builder.build();
    }
}

