/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.ocpjava.protocol.impl.deserialization.factories;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.opendaylight.ocpjava.protocol.api.extensibility.OCPDeserializer;
import org.opendaylight.ocpjava.protocol.impl.core.XmlCharacters;
import org.opendaylight.ocpjava.protocol.impl.core.XmlElementEnd;
import org.opendaylight.ocpjava.protocol.impl.core.XmlElementStart;
import org.opendaylight.ocpjava.protocol.impl.deserialization.factories.utils.MessageHelper;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.GetParamRes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.ObjId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.OcpMsgType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.getparamoutput.Obj;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.getparamoutput.ObjBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.getparamoutput.obj.Param;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.getparamoutput.obj.ParamBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.protocol.rev150811.GetParamOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.protocol.rev150811.GetParamOutputBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetParamOutputFactory
implements OCPDeserializer<GetParamOutput> {
    private static final Logger LOGGER = LoggerFactory.getLogger(GetParamOutputFactory.class);

    public GetParamOutput deserialize(List<Object> rawMessage) {
        GetParamOutputBuilder builder = new GetParamOutputBuilder();
        ObjBuilder objbuilder = new ObjBuilder();
        ParamBuilder parambuilder = new ParamBuilder();
        ArrayList<Param> paramlist = new ArrayList<Param>();
        ArrayList<Obj> objlist = new ArrayList<Obj>();
        Iterator<Object> itr = rawMessage.iterator();
        while (itr.hasNext()) {
            Object tok = itr.next();
            LOGGER.trace("GetParamOutputFactory - itr = " + tok);
            try {
                if (!(tok instanceof XmlElementStart)) continue;
                if (((XmlElementStart)tok).name().equals("body")) {
                    String type = MessageHelper.getMsgType(itr);
                    builder.setMsgType(OcpMsgType.valueOf((String)type));
                    continue;
                }
                if (((XmlElementStart)tok).name().equals("msgUID")) {
                    String uidStr = MessageHelper.getMsgUID(itr);
                    int uid = Integer.parseInt(uidStr);
                    builder.setXid(Long.valueOf(uid));
                    continue;
                }
                if (((XmlElementStart)tok).name().equals("result")) {
                    String rel = MessageHelper.getResult(itr);
                    builder.setResult(GetParamRes.valueOf((String)rel));
                    continue;
                }
                if (!((XmlElementStart)tok).name().equals("obj")) continue;
                if (((XmlElementStart)tok).attributes().size() >= 1) {
                    objbuilder.setId(new ObjId(((XmlElementStart)tok).attributes().get(0).value()));
                }
                LOGGER.debug("GetParamOutputFactory - objbuilder getId = " + objbuilder.getId());
                Object objtok = itr.next();
                while (!(objtok instanceof XmlElementStart)) {
                    objtok = itr.next();
                }
                while (!((XmlElementStart)objtok).name().equals("obj")) {
                    if (((XmlElementStart)objtok).name().equals("param")) {
                        if (((XmlElementStart)objtok).attributes().size() >= 1) {
                            parambuilder.setName(((XmlElementStart)objtok).attributes().get(0).value());
                        }
                        LOGGER.debug("GetParamOutputFactory - parambuilder getName = " + parambuilder.getName());
                        String bufStr = MessageHelper.getCharVal(itr);
                        parambuilder.setValue(bufStr);
                        LOGGER.debug("GetParamOutputFactory - parambuilder getValue = " + parambuilder.getValue());
                        paramlist.add(parambuilder.build());
                        parambuilder = new ParamBuilder();
                    }
                    objtok = itr.next();
                    while (!(!(objtok instanceof XmlElementStart) && !(objtok instanceof XmlElementEnd) && !(objtok instanceof XmlCharacters) || objtok instanceof XmlElementStart && ((XmlElementStart)objtok).name().equals("param") || objtok instanceof XmlElementEnd && ((XmlElementEnd)objtok).name().equals("obj"))) {
                        objtok = itr.next();
                    }
                    if (!(objtok instanceof XmlElementEnd) || !((XmlElementEnd)objtok).name().equals("obj")) continue;
                }
                objbuilder.setParam(paramlist);
                paramlist = new ArrayList();
                LOGGER.trace("GetParamOutputFactory - objbuilder.build(): " + objbuilder.build());
                objlist.add(objbuilder.build());
            }
            catch (Exception t) {
                LOGGER.error("Error " + tok + " " + t.toString());
            }
        }
        builder.setObj(objlist);
        LOGGER.debug("GetParamOutputFactory - Builder: " + builder.build());
        return builder.build();
    }
}

