/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.ocpjava.protocol.impl.deserialization.factories;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.opendaylight.ocpjava.protocol.api.extensibility.OCPDeserializer;
import org.opendaylight.ocpjava.protocol.impl.core.XmlCharacters;
import org.opendaylight.ocpjava.protocol.impl.core.XmlElementEnd;
import org.opendaylight.ocpjava.protocol.impl.core.XmlElementStart;
import org.opendaylight.ocpjava.protocol.impl.deserialization.factories.utils.MessageHelper;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.GetStateRes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.ObjId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.OcpMsgType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.StateType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.StateVal;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.getstateoutput.Obj;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.getstateoutput.ObjBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.getstateoutput.obj.State;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.getstateoutput.obj.StateBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.protocol.rev150811.GetStateOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.protocol.rev150811.GetStateOutputBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetStateOutputFactory
implements OCPDeserializer<GetStateOutput> {
    private static final Logger LOGGER = LoggerFactory.getLogger(GetStateOutputFactory.class);

    public GetStateOutput deserialize(List<Object> rawMessage) {
        GetStateOutputBuilder builder = new GetStateOutputBuilder();
        ArrayList<Obj> objlist = new ArrayList<Obj>();
        Iterator<Object> itr = rawMessage.iterator();
        while (itr.hasNext()) {
            Object tok = itr.next();
            LOGGER.trace("GetStateOutputFactory - itr = " + tok);
            try {
                if (!(tok instanceof XmlElementStart)) continue;
                if (((XmlElementStart)tok).name().equals("body")) {
                    String type = MessageHelper.getMsgType(itr);
                    builder.setMsgType(OcpMsgType.valueOf((String)type));
                    continue;
                }
                if (((XmlElementStart)tok).name().equals("msgUID")) {
                    String uidStr = MessageHelper.getMsgUID(itr);
                    int uid = Integer.parseInt(uidStr);
                    builder.setXid(Long.valueOf(uid));
                    continue;
                }
                if (((XmlElementStart)tok).name().equals("result")) {
                    String rel = MessageHelper.getResult(itr);
                    builder.setResult(GetStateRes.valueOf((String)rel));
                    continue;
                }
                if (!((XmlElementStart)tok).name().equals("obj")) continue;
                ObjBuilder objbuilder = new ObjBuilder();
                objbuilder.setId(new ObjId(((XmlElementStart)tok).attributes().get(0).value()));
                LOGGER.trace("GetStateOutputFactory - getId = " + objbuilder.getId());
                Object objtok = itr.next();
                while (!(objtok instanceof XmlElementStart)) {
                    objtok = itr.next();
                }
                StateBuilder statebuilder = new StateBuilder();
                ArrayList<State> statelist = new ArrayList<State>();
                while (objtok instanceof XmlElementStart) {
                    if (((XmlElementStart)objtok).name().equals("state")) {
                        String tmp = ((XmlElementStart)objtok).attributes().get(0).value();
                        statebuilder.setType(StateType.valueOf((String)tmp));
                        LOGGER.trace("GetStateOutputFactory - getType = " + statebuilder.getType());
                        String bufStr = MessageHelper.getMsgUID(itr);
                        statebuilder.setValue(StateVal.valueOf((String)bufStr));
                        LOGGER.trace("GetStateOutputFactory - getValue = " + statebuilder.getValue());
                        statelist.add(statebuilder.build());
                        objtok = itr.next();
                        while (objtok instanceof XmlCharacters) {
                            objtok = itr.next();
                        }
                        LOGGER.debug("ModifyStateOutputFactory - found next: {}", objtok);
                    }
                    if (objtok instanceof XmlElementEnd) {
                        LOGGER.debug("GetStateOutputFactory - found XmlElementEnd: {}", objtok);
                        if (!((XmlElementEnd)objtok).name().equals("obj")) continue;
                        LOGGER.debug("GetStateOutputFactory - objtok20 = " + objtok);
                        continue;
                    }
                    while (!(objtok instanceof XmlElementStart)) {
                        objtok = itr.next();
                    }
                }
                objbuilder.setState(statelist);
                LOGGER.trace("GetStateOutputFactory - objbuilder.build() = " + objbuilder.build());
                objlist.add(objbuilder.build());
            }
            catch (Exception t) {
                LOGGER.error("Error " + tok + " " + t.toString());
            }
        }
        builder.setObj(objlist);
        LOGGER.debug("GetStateOutputFactory - Builder: " + builder.build());
        return builder.build();
    }
}

