/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.ocpjava.protocol.impl.deserialization.factories;

import java.util.Iterator;
import java.util.List;
import org.opendaylight.ocpjava.protocol.api.extensibility.OCPDeserializer;
import org.opendaylight.ocpjava.protocol.impl.core.XmlElementStart;
import org.opendaylight.ocpjava.protocol.impl.deserialization.factories.utils.MessageHelper;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.OcpMsgType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.extension.rev150811.HelloInd;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.extension.rev150811.HelloMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.extension.rev150811.HelloMessageBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HelloMessageFactory
implements OCPDeserializer<HelloInd> {
    private static final Logger LOGGER = LoggerFactory.getLogger(HelloMessageFactory.class);

    public HelloMessage deserialize(List<Object> rawMessage) {
        HelloMessageBuilder builder = new HelloMessageBuilder();
        Iterator<Object> itr = rawMessage.iterator();
        while (itr.hasNext()) {
            Object tok = itr.next();
            LOGGER.trace("HelloMessageFactory - itr = " + tok);
            try {
                if (!(tok instanceof XmlElementStart)) continue;
                if (((XmlElementStart)tok).name().equals("body")) {
                    String type = MessageHelper.getMsgType(itr);
                    builder.setMsgType(OcpMsgType.valueOf((String)type));
                    continue;
                }
                if (((XmlElementStart)tok).name().equals("msgUID")) {
                    String uidStr = MessageHelper.getMsgUID(itr);
                    int uid = Integer.parseInt(uidStr);
                    builder.setXid(Long.valueOf(uid));
                    continue;
                }
                if (((XmlElementStart)tok).name().equals("version")) {
                    String ver = MessageHelper.getCharVal(itr);
                    builder.setVersion(ver);
                    continue;
                }
                if (((XmlElementStart)tok).name().equals("vendorId")) {
                    String verId = MessageHelper.getCharVal(itr);
                    builder.setVendorId(verId);
                    continue;
                }
                if (!((XmlElementStart)tok).name().equals("serialNumber")) continue;
                String serNum = MessageHelper.getCharVal(itr);
                builder.setSerialNumber(serNum);
            }
            catch (Exception t) {
                LOGGER.error("Error " + tok + " " + t.toString());
            }
        }
        LOGGER.debug("HelloMessageFactory - Builder: " + builder.build());
        return builder.build();
    }
}

