/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.ocpjava.protocol.impl.serialization.factories;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import org.opendaylight.ocpjava.protocol.api.extensibility.OCPSerializer;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.createobjinput.Param;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.protocol.rev150811.CreateObjInput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateObjInputFactory
implements OCPSerializer<CreateObjInput> {
    private static final String MESSAGE_TYPE = "createObjReq";
    private static final Logger LOGGER = LoggerFactory.getLogger(CreateObjInputFactory.class);

    public void serialize(CreateObjInput message, ByteBuf outBuffer) {
        LOGGER.debug("CreateObjInputFactory - message = " + message.toString());
        StringBuilder seq = new StringBuilder("");
        seq.append("<msg xmlns=");
        seq.append("\"http://uri.etsi.org/ori/002-2/v4.1.1\">");
        seq.append("<header>");
        seq.append("<msgType>REQ</msgType>");
        seq.append("<msgUID>");
        seq.append(message.getXid().toString());
        seq.append("</msgUID>");
        seq.append("</header>");
        seq.append("<body>");
        seq.append("<");
        seq.append(MESSAGE_TYPE);
        seq.append(">");
        seq.append("<objType objTypeID=\"");
        seq.append(message.getObjType().getValue());
        seq.append("\">");
        if (message.getParam() != null) {
            for (Param currParam : message.getParam()) {
                seq.append("<param name=\"");
                seq.append(currParam.getName());
                seq.append("\">");
                seq.append(currParam.getValue());
                seq.append("</param>");
            }
        }
        seq.append("</objType>");
        seq.append("</");
        seq.append(MESSAGE_TYPE);
        seq.append(">");
        seq.append("</body>");
        seq.append("</msg>");
        LOGGER.debug("CreateObjInputFactory - composed xml-string = " + seq);
        ByteBufUtil.writeUtf8((ByteBuf)outBuffer, (CharSequence)seq);
    }
}

