/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.ocpjava.protocol.impl.serialization.factories;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import org.opendaylight.ocpjava.protocol.api.extensibility.OCPSerializer;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.protocol.rev150811.HealthCheckInput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HealthCheckInputFactory
implements OCPSerializer<HealthCheckInput> {
    private static final Logger LOGGER = LoggerFactory.getLogger(HealthCheckInputFactory.class);

    public void serialize(HealthCheckInput message, ByteBuf outBuffer) {
        LOGGER.debug("HealthCheckInputFactory - message = " + message.toString());
        StringBuilder seq = new StringBuilder("");
        seq.append("<msg xmlns=");
        seq.append("\"http://uri.etsi.org/ori/002-2/v4.1.1\">");
        seq.append("<header>");
        seq.append("<msgType>REQ</msgType>");
        seq.append("<msgUID>");
        seq.append(message.getXid().toString());
        seq.append("</msgUID>");
        seq.append("</header>");
        seq.append("<body>");
        seq.append("<healthCheckReq>");
        seq.append("<tcpLinkMonTimeout>");
        seq.append(message.getTcpLinkMonTimeout().getValue().toString());
        seq.append("</tcpLinkMonTimeout>");
        seq.append("</healthCheckReq>");
        seq.append("</body>");
        seq.append("</msg>");
        LOGGER.debug("HealthCheckInputFactory - composed xml-string = " + seq);
        ByteBufUtil.writeUtf8((ByteBuf)outBuffer, (CharSequence)seq);
    }
}

