/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.ocpjava.protocol.impl.serialization.factories;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import org.opendaylight.ocpjava.protocol.api.extensibility.OCPSerializer;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.modifyparaminput.Param;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.protocol.rev150811.ModifyParamInput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModifyParamInputFactory
implements OCPSerializer<ModifyParamInput> {
    private static final String MESSAGE_TYPE = "modifyParamReq";
    private static final Logger LOGGER = LoggerFactory.getLogger(ModifyParamInputFactory.class);

    public void serialize(ModifyParamInput message, ByteBuf outBuffer) {
        LOGGER.debug("ModifyParamInputFactory - message = " + message.toString());
        StringBuilder seq = new StringBuilder("");
        seq.append("<msg xmlns=");
        seq.append("\"http://uri.etsi.org/ori/002-2/v4.1.1\">");
        seq.append("<header>");
        seq.append("<msgType>REQ</msgType>");
        seq.append("<msgUID>");
        seq.append(message.getXid().toString());
        seq.append("</msgUID>");
        seq.append("</header>");
        seq.append("<body>");
        seq.append("<");
        seq.append(MESSAGE_TYPE);
        seq.append(">");
        seq.append("<obj objID=\"");
        seq.append(message.getObjId().getValue().toString());
        seq.append("\">");
        for (Param currParam : message.getParam()) {
            seq.append("<param name=\"");
            seq.append(currParam.getName());
            seq.append("\">");
            seq.append(currParam.getValue());
            seq.append("</param>");
        }
        seq.append("</obj>");
        seq.append("</");
        seq.append(MESSAGE_TYPE);
        seq.append(">");
        seq.append("</body>");
        seq.append("</msg>");
        LOGGER.debug("ModifyParamInputFactory - composed xml-string = " + seq);
        ByteBufUtil.writeUtf8((ByteBuf)outBuffer, (CharSequence)seq);
    }
}

